/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketState;
import de.torui.coflsky.CoflSky;
import de.torui.coflsky.WSCommandHandler;
import de.torui.coflsky.commands.Command;
import de.torui.coflsky.commands.JsonStringCommand;
import de.torui.coflsky.commands.RawCommand;
import de.torui.coflsky.network.NaiveSSLContext;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;

public class WSClient
extends WebSocketAdapter {
    public static Gson gson = new GsonBuilder().create();
    public URI uri;
    public WebSocket socket;
    public boolean shouldRun = false;
    public WebSocketState currentState = WebSocketState.CLOSED;

    public WSClient(URI uri) {
        this.uri = uri;
    }

    public void start() throws IOException, WebSocketException, NoSuchAlgorithmException {
        WebSocketFactory factory = new WebSocketFactory();
        factory.setVerifyHostname(false);
        factory.setSSLContext(NaiveSSLContext.getInstance("TLSv1.2"));
        factory.setConnectionTimeout(10000);
        this.socket = factory.createSocket(this.uri);
        this.socket.addListener(this);
        this.socket.connect();
    }

    public void stop() {
        System.out.println("Closing Socket");
        this.socket.clearListeners();
        this.socket.disconnect();
        System.out.println("Socket closed");
    }

    @Override
    public void onStateChanged(WebSocket websocket, WebSocketState newState) throws Exception {
        System.out.println("WebSocket Changed state to: " + (Object)((Object)newState));
        this.currentState = newState;
        if (newState == WebSocketState.CLOSED && this.shouldRun) {
            CoflSky.Wrapper.restartWebsocketConnection();
        }
        super.onStateChanged(websocket, newState);
    }

    @Override
    public void onTextMessage(WebSocket websocket, String text) throws Exception {
        System.out.println("Received: " + text);
        JsonStringCommand cmd = (JsonStringCommand)gson.fromJson(text, JsonStringCommand.class);
        WSCommandHandler.HandleCommand(cmd, (Entity)Minecraft.func_71410_x().field_71439_g);
    }

    public void SendCommand(Command cmd) {
        this.SendCommand(new RawCommand(cmd.getType().ToJson(), gson.toJson(cmd.getData())));
    }

    public void SendCommand(RawCommand cmd) {
        this.Send(cmd);
    }

    public void Send(Object obj) {
        String json = gson.toJson(obj);
        System.out.println("###Sending message of json value " + json);
        if (this.socket == null) {
            try {
                this.start();
            }
            catch (Exception e) {
                System.out.println("Ran into an error on implicit start for send: " + e);
            }
        }
        this.socket.sendText(json);
    }
}

