/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky;

import com.google.gson.reflect.TypeToken;
import de.torui.coflsky.CoflSky;
import de.torui.coflsky.CountdownTimer;
import de.torui.coflsky.FlipHandler;
import de.torui.coflsky.commands.Command;
import de.torui.coflsky.commands.CommandType;
import de.torui.coflsky.commands.JsonStringCommand;
import de.torui.coflsky.commands.models.ChatMessageData;
import de.torui.coflsky.commands.models.FlipData;
import de.torui.coflsky.commands.models.SoundData;
import de.torui.coflsky.commands.models.TimerData;
import de.torui.coflsky.configuration.ConfigurationManager;
import de.torui.coflsky.handlers.EventRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;

public class WSCommandHandler {
    public static transient String lastOnClickEvent;
    public static FlipHandler flipHandler;

    public static boolean HandleCommand(JsonStringCommand cmd, Entity sender) {
        System.out.println("Handling Command=" + cmd.toString());
        switch (cmd.getType()) {
            case WriteToChat: {
                WSCommandHandler.WriteToChat(cmd.GetAs(new TypeToken<ChatMessageData>(){}));
                break;
            }
            case Execute: {
                WSCommandHandler.Execute(cmd.GetAs(new TypeToken<String>(){}), sender);
                break;
            }
            case PlaySound: {
                WSCommandHandler.PlaySound(cmd.GetAs(new TypeToken<SoundData>(){}), sender);
                break;
            }
            case ChatMessage: {
                WSCommandHandler.ChatMessage(cmd.GetAs(new TypeToken<ChatMessageData[]>(){}));
                break;
            }
            case Flip: {
                WSCommandHandler.Flip(cmd.GetAs(new TypeToken<FlipData>(){}));
                break;
            }
            case PrivacySettings: {
                new ConfigurationManager().UpdateConfiguration((String)cmd.getData());
            }
            case Countdown: {
                WSCommandHandler.StartTimer(cmd.GetAs(new TypeToken<TimerData>(){}));
                break;
            }
        }
        return true;
    }

    private static void Flip(Command<FlipData> cmd) {
        ChatMessageData[] messages = cmd.getData().Messages;
        Command<ChatMessageData[]> showCmd = new Command<ChatMessageData[]>(CommandType.ChatMessage, messages);
        WSCommandHandler.ChatMessage(showCmd);
        WSCommandHandler.flipHandler.fds.Insert(new FlipHandler.Flip(cmd.getData().Id, cmd.getData().Worth));
        CoflSky.Events.onEvent(null);
    }

    private static void PlaySound(Command<SoundData> cmd, Entity sender) {
        SoundData sc = cmd.getData();
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        PositionedSoundRecord psr = PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(sc.Name), (float)sc.Pitch);
        handler.func_147682_a((ISound)psr);
    }

    private static void Execute(Command<String> cmd, Entity sender) {
        System.out.println("Execute: " + cmd.getData() + " sender:" + sender);
        WSCommandHandler.Execute(cmd.getData(), sender);
    }

    private static void StartTimer(Command<TimerData> cmd) {
        CountdownTimer.startCountdown(cmd.getData());
    }

    public static void Execute(String cmd, Entity sender) {
        if (cmd.startsWith("/viewauction")) {
            String uuid;
            String[] args = cmd.split(" ");
            EventRegistry.LastViewAuctionUUID = uuid = args[args.length - 1];
            EventRegistry.LastViewAuctionInvocation = System.currentTimeMillis();
        }
        if (cmd.startsWith("/cofl") || cmd.startsWith("http")) {
            ClientCommandHandler.instance.func_71556_a((ICommandSender)sender, cmd);
        } else {
            Minecraft.func_71410_x().field_71439_g.func_71165_d(cmd);
        }
    }

    private static IChatComponent CommandToChatComponent(ChatMessageData wcmd) {
        if (wcmd.OnClick != null) {
            lastOnClickEvent = "/cofl callback " + wcmd.OnClick;
        }
        if (wcmd.Text != null) {
            ChatComponentText comp = new ChatComponentText(wcmd.Text);
            if (wcmd.OnClick != null) {
                ChatStyle style = wcmd.OnClick.startsWith("http") ? new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, wcmd.OnClick)) : new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/cofl callback " + wcmd.OnClick));
                comp.func_150255_a(style);
            }
            if (wcmd.Hover != null && !wcmd.Hover.isEmpty()) {
                if (comp.func_150256_b() == null) {
                    comp.func_150255_a(new ChatStyle());
                }
                comp.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(wcmd.Hover)));
            }
            return comp;
        }
        return null;
    }

    private static void ChatMessage(Command<ChatMessageData[]> cmd) {
        ChatMessageData[] list = cmd.getData();
        ChatComponentText master = new ChatComponentText("");
        for (ChatMessageData wcmd : list) {
            IChatComponent comp = WSCommandHandler.CommandToChatComponent(wcmd);
            if (comp == null) continue;
            master.func_150257_a(comp);
        }
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)master);
    }

    private static void WriteToChat(Command<ChatMessageData> cmd) {
        ChatMessageData wcmd = cmd.getData();
        IChatComponent comp = WSCommandHandler.CommandToChatComponent(wcmd);
        if (comp != null) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a(comp);
        }
    }

    static {
        flipHandler = new FlipHandler();
    }
}

