/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky;

import de.torui.coflsky.CoflSky;
import de.torui.coflsky.WSCommandHandler;
import de.torui.coflsky.commands.Command;
import de.torui.coflsky.commands.CommandType;
import de.torui.coflsky.commands.JsonStringCommand;
import de.torui.coflsky.commands.RawCommand;
import de.torui.coflsky.minecraft_integration.CoflSessionManager;
import de.torui.coflsky.minecraft_integration.PlayerDataProvider;
import de.torui.coflsky.network.QueryServerCommands;
import de.torui.coflsky.network.WSClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CoflSkyCommand
extends CommandBase {
    public static final String HelpText = "Available local sub-commands:\n\u00a7bstart: \u00a77starts a new connection\n\u00a7bstop: \u00a77stops the connection\n\u00a7bconnect: \u00a77Connects to a different server\n\u00a7breset: \u00a77resets all local session information and stops the connection\n\u00a7bstatus: \u00a77Emits status information\nServer-Only Commands:";

    public int func_82362_a() {
        return 0;
    }

    public String func_71517_b() {
        return "cofl";
    }

    public List func_71514_a() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("Cofl");
        al.add("coflnet");
        al.add("cl");
        return al;
    }

    public String func_71518_a(ICommandSender sender) {
        return HelpText;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        new Thread(() -> {
            System.out.println(Arrays.toString(args));
            if (args.length >= 1) {
                switch (args[0]) {
                    case "start": {
                        CoflSky.Wrapper.stop();
                        sender.func_145747_a((IChatComponent)new ChatComponentText("starting connection..."));
                        CoflSky.Wrapper.startConnection();
                        break;
                    }
                    case "stop": {
                        CoflSky.Wrapper.stop();
                        sender.func_145747_a(new ChatComponentText("you stopped the connection to ").func_150257_a(new ChatComponentText("C").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_BLUE))).func_150257_a(new ChatComponentText("oflnet").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD))).func_150257_a((IChatComponent)new ChatComponentText(".\n    To reconnect enter ")).func_150257_a(new ChatComponentText("\"").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.AQUA))).func_150257_a((IChatComponent)new ChatComponentText("/cofl start")).func_150257_a(new ChatComponentText("\"").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.AQUA))).func_150257_a((IChatComponent)new ChatComponentText(" or click this message")).func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/cofl start"))));
                        break;
                    }
                    case "debug": {
                        break;
                    }
                    case "callback": {
                        this.CallbackCommand(args);
                        break;
                    }
                    case "status": {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(this.StatusMessage()));
                        break;
                    }
                    case "reset": {
                        this.HandleReset();
                        break;
                    }
                    case "connect": {
                        if (args.length == 2) {
                            String destination = args[1];
                            if (!destination.contains("://")) {
                                destination = new String(Base64.getDecoder().decode(destination));
                            }
                            sender.func_145747_a((IChatComponent)new ChatComponentText("Stopping connection!"));
                            CoflSky.Wrapper.stop();
                            sender.func_145747_a((IChatComponent)new ChatComponentText("Opening connection to " + destination));
                            if (CoflSky.Wrapper.initializeNewSocket(destination)) {
                                sender.func_145747_a((IChatComponent)new ChatComponentText("Success"));
                                break;
                            }
                            sender.func_145747_a((IChatComponent)new ChatComponentText("Could not open connection, please check the logs"));
                            break;
                        }
                        sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cPleace specify a server to connect to"));
                        break;
                    }
                    default: {
                        this.SendCommandToServer(args, sender);
                        return;
                    }
                }
            } else {
                this.ListHelp(sender);
            }
        }).start();
    }

    private void HandleReset() {
        CoflSky.Wrapper.SendMessage(new Command<String>(CommandType.Reset, ""));
        CoflSky.Wrapper.stop();
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Stopping Connection to CoflNet"));
        CoflSessionManager.DeleteAllCoflSessions();
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Deleting CoflNet sessions..."));
        if (CoflSky.Wrapper.startConnection()) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Started the Connection to CoflNet"));
        }
    }

    public String StatusMessage() {
        String vendor = System.getProperty("java.vm.vendor");
        String name = System.getProperty("java.vm.name");
        String version = System.getProperty("java.version");
        String detailedVersion = System.getProperty("java.vm.version");
        String status = vendor + " " + name + " " + version + " " + detailedVersion + "|Connection = " + (CoflSky.Wrapper != null ? CoflSky.Wrapper.GetStatus() : "UNINITIALIZED_WRAPPER");
        try {
            status = status + "  uri=" + CoflSky.Wrapper.socket.uri.toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            CoflSessionManager.CoflSession session = CoflSessionManager.GetCoflSession(PlayerDataProvider.getUsername());
            String sessionString = CoflSessionManager.gson.toJson((Object)session);
            status = status + "  session=" + sessionString;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    public void SendCommandToServer(String[] args, ICommandSender sender) {
        String command = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        RawCommand rc = new RawCommand(args[0], WSClient.gson.toJson((Object)command));
        if (CoflSky.Wrapper.isRunning) {
            CoflSky.Wrapper.SendMessage(rc);
        } else {
            sender.func_145747_a(new ChatComponentText("CoflSky wasn't active.").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            CoflSky.Wrapper.stop();
            CoflSky.Wrapper.startConnection();
            CoflSky.Wrapper.SendMessage(rc);
        }
    }

    public void ListHelp(ICommandSender sender) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(HelpText));
        sender.func_145747_a((IChatComponent)new ChatComponentText(QueryServerCommands.QueryCommands()));
    }

    public void CallbackCommand(String[] args) {
        String command = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        System.out.println("CallbackData: " + command);
        System.out.println("Callback: " + command);
        WSCommandHandler.HandleCommand(new JsonStringCommand(CommandType.Execute, WSClient.gson.toJson((Object)command)), (Entity)Minecraft.func_71410_x().field_71439_g);
        CoflSky.Wrapper.SendMessage(new JsonStringCommand(CommandType.Clicked, WSClient.gson.toJson((Object)command)));
        System.out.println("Sent!");
    }
}

