/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class FlipHandler {
    public FlipDataStructure fds = new FlipDataStructure();

    public static class FlipDataStructure {
        private Map<Long, Flip> Flips = new ConcurrentHashMap<Long, Flip>();
        private Map<Flip, Long> ReverseMap = new ConcurrentHashMap<Flip, Long>();
        private Flip HighestFlip = null;
        private Timer t = new Timer();
        private TimerTask CurrentTask = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void RunHouseKeeping() {
            Map<Long, Flip> map = this.Flips;
            synchronized (map) {
                Long RemoveAllPrior = System.currentTimeMillis() - 42000L;
                this.Flips.keySet().stream().filter(l -> l <= RemoveAllPrior).forEach(l -> this.RemoveLong((Long)l));
                this.HighestFlip = !this.Flips.isEmpty() ? (Flip)this.Flips.values().stream().max((f1, f2) -> f1.worth - f2.worth).orElse(null) : null;
            }
            if (this.CurrentTask != null) {
                this.CurrentTask.cancel();
                this.CurrentTask = null;
                this.t.purge();
            }
            if (!this.Flips.isEmpty()) {
                this.CurrentTask = new TimerTask(){

                    @Override
                    public void run() {
                        this.RunHouseKeeping();
                    }
                };
                this.t.schedule(this.CurrentTask, 42150L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Insert(Flip flip) {
            Long l = System.currentTimeMillis();
            Map<Long, Flip> map = this.Flips;
            synchronized (map) {
                this.Flips.put(l, flip);
                this.ReverseMap.put(flip, l);
            }
            this.RunHouseKeeping();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void RemoveLong(Long l) {
            if (l == null) {
                return;
            }
            Map<Long, Flip> map = this.Flips;
            synchronized (map) {
                Flip f = this.Flips.get(l);
                if (f != null) {
                    this.ReverseMap.remove(f);
                    this.Flips.remove(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void RemoveFlip(Flip f) {
            if (f == null) {
                return;
            }
            Map<Long, Flip> map = this.Flips;
            synchronized (map) {
                Long l = this.ReverseMap.get(f);
                if (l != null) {
                    this.Flips.remove(l);
                    this.ReverseMap.remove(f);
                }
            }
        }

        public Flip GetHighestFlip() {
            return this.HighestFlip;
        }

        public void InvalidateFlip(Flip flip) {
            this.RemoveFlip(flip);
            this.RunHouseKeeping();
        }

        public int CurrentFlips() {
            return this.Flips.size();
        }
    }

    public static class Flip {
        public String id;
        public int worth;

        public Flip(String id, int worth) {
            this.id = id;
            this.worth = worth;
        }

        public Flip() {
        }
    }
}

