/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.gui;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class RenderUtils {
    public static class_289 tessellator = null;
    private static class_287 buffer = null;
    public static class_327 textRenderer = null;
    public static int z = 0;

    public static void init() {
        z = 0;
        tessellator = class_289.method_1348();
        textRenderer = class_310.method_1551().field_1772;
    }

    public static void drawRect(class_332 context, float x, float y, float width, float height, int color) {
        buffer = tessellator.method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(context.method_51448().method_23760().method_23761(), x, y, (float)z).method_39415(color);
        buffer.method_22918(context.method_51448().method_23760().method_23761(), x, y + height, (float)z).method_39415(color);
        buffer.method_22918(context.method_51448().method_23760().method_23761(), x + width, y + height, (float)z).method_39415(color);
        buffer.method_22918(context.method_51448().method_23760().method_23761(), x + width, y, (float)z).method_39415(color);
        class_1921.method_51784().method_60895(buffer.method_60800());
    }

    public static void drawRectOutline(class_332 context, int x, int y, int width, int height, float lineWidth, int fillCol, int lineCol) {
        RenderUtils.drawRect(context, x, y, width, height, lineCol);
        RenderUtils.drawRect(context, (float)x + lineWidth, (float)y + lineWidth, (float)width - lineWidth * 2.0f, (float)height - lineWidth * 2.0f, fillCol);
    }

    public static void drawCircle(class_332 context, int x, int y, int radius, int color) {
        buffer = tessellator.method_60827(VertexFormat.class_5596.field_27380, class_290.field_1576);
        for (int i = 0; i <= 360; ++i) {
            buffer.method_22918(context.method_51448().method_23760().method_23761(), (float)((double)x + Math.sin((double)i * Math.PI / 180.0) * (double)radius), (float)((double)y + Math.cos((double)i * Math.PI / 180.0) * (double)radius), (float)z).method_39415(color);
        }
        class_1921.method_51784().method_60895(buffer.method_60800());
    }

    public static void drawCircleOutline(class_332 context, int x, int y, int radius, int thickness, int fillCol, int lineCol) {
        RenderUtils.drawCircle(context, x, y, radius, lineCol);
        RenderUtils.drawCircle(context, x, y, radius + thickness * 2, fillCol);
    }

    public static void drawLine(float x1, float y1, float x2, float y2, float thickness, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glLineWidth((float)thickness);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawTriangle(int x, int y, int x2, int y2, int x3, int y3, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x3, (double)y3);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawTriangleOutline(int x, int y, int x2, int y2, int x3, int y3, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x3, (double)y3);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawArc(class_332 context, int x, int y, int radius, int startAngle, int endAngle, int color) {
        buffer = tessellator.method_60827(VertexFormat.class_5596.field_27381, class_290.field_1576);
        for (int i = startAngle; i <= endAngle; ++i) {
            buffer.method_22918(context.method_51448().method_23760().method_23761(), (float)((double)x + Math.sin((double)i * Math.PI / 180.0) * (double)radius), (float)((double)y + Math.cos((double)i * Math.PI / 180.0) * (double)radius), (float)z).method_39415(color);
        }
        class_1921.method_51784().method_60895(buffer.method_60800());
    }

    public static void drawLoadingCircle(class_332 context, float x, float y, float radius, float thickness, float speed, int color) {
        buffer = tessellator.method_60827(VertexFormat.class_5596.field_27378, class_290.field_1576);
        for (int i = 0; i <= 360; ++i) {
            buffer.method_22918(context.method_51448().method_23760().method_23761(), (float)((double)x + Math.sin((double)((float)i + speed) * Math.PI / 180.0) * (double)radius), (float)((double)y + Math.cos((double)((float)i + speed) * Math.PI / 180.0) * (double)radius), (float)z).method_39415(color);
        }
        class_1921.method_51784().method_60895(buffer.method_60800());
    }

    public static void drawRoundedRect(class_332 context, int x, int y, int width, int height, int radius, @NotNull int color) {
        RenderUtils.drawRect(context, x + radius, y, width - radius * 2, height, color);
        RenderUtils.drawRect(context, x, y + radius, radius, height - radius * 2, color);
        RenderUtils.drawRect(context, x + width - radius, y + radius, radius, height - radius * 2, color);
        RenderUtils.drawCircle(context, x + radius, y + radius, radius, color);
        RenderUtils.drawCircle(context, x + width - radius, y + radius, radius, color);
        RenderUtils.drawCircle(context, x + radius, y + height - radius, radius, color);
        RenderUtils.drawCircle(context, x + width - radius, y + height - radius, radius, color);
    }

    public static void drawGradientRect(int x, int y, int width, int height, Color color1, Color color2) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        GL11.glBegin((int)7);
        RenderUtils.setColor(color1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)(x + width), (double)y);
        RenderUtils.setColor(color2);
        GL11.glVertex2d((double)(x + width), (double)(y + height));
        GL11.glVertex2d((double)x, (double)(y + height));
        GL11.glEnd();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawString(class_332 context, String text, int x, int y, int color) {
        context.method_51433(textRenderer, text, x, y, color, false);
    }

    public static void drawStringWithShadow(class_332 context, String text, int x, int y, int color) {
        context.method_51433(textRenderer, text, x, y, color, true);
    }

    public static void drawCenteredString(class_332 context, String text, int x, int y, int color) {
        context.method_51433(textRenderer, text, x - textRenderer.method_1727(text) / 2, y, color, false);
    }

    public static void drawCenteredStringWithShadow(class_332 context, String text, int x, int y, int color) {
        context.method_51433(textRenderer, text, x - textRenderer.method_1727(text) / 2, y, color, true);
    }

    private static void drawString(class_332 context, String text, int x, int y, int color, int scale, boolean centered, boolean shadow) {
        class_4587 ms = context.method_51448();
        ms.method_22903();
        ms.method_22905((float)scale, (float)scale, 0.0f);
        context.method_51433(textRenderer, text, centered ? x - textRenderer.method_1727(text) / 2 : x, y, color, shadow);
        ms.method_22909();
    }

    public static void drawString(class_332 context, String text, int x, int y, int color, int scale) {
        RenderUtils.drawString(context, text, x, y, color, scale, false, false);
    }

    public static void drawStringWithShadow(class_332 context, String text, int x, int y, int color, int scale) {
        RenderUtils.drawString(context, text, x, y, color, scale, false, true);
    }

    public static void drawCenteredString(class_332 context, String text, int x, int y, int color, int scale) {
        RenderUtils.drawString(context, text, x, y, color, scale, true, false);
    }

    public static void drawCenteredStringWithShadow(class_332 context, String text, int x, int y, int color, int scale) {
        RenderUtils.drawString(context, text, x, y, color, scale, true, true);
    }

    public static void drawItemStack(class_332 context, class_1799 itemStack, int x, int y, float scale) {
        context.method_51429(itemStack, x, y, 0, z);
    }

    public static Color setAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static void setColor(int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void setColor(Color color) {
        RenderUtils.setColor(color.getRGB());
    }

    public static void rotate(float angle) {
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static String lorem() {
        return "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. +Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet,";
    }
}

