/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet;

import CoflCore.CoflCore;
import CoflCore.CoflSkyCommand;
import CoflCore.commands.Command;
import CoflCore.commands.CommandType;
import CoflCore.commands.models.FlipData;
import CoflCore.configuration.GUIType;
import CoflCore.handlers.DescriptionHandler;
import CoflCore.handlers.EventRegistry;
import com.coflnet.EventSubscribers;
import com.coflnet.gui.RenderUtils;
import com.coflnet.gui.cofl.CoflBinGUI;
import com.coflnet.gui.tfm.TfmBinGUI;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_8646;
import net.minecraft.class_9015;
import net.minecraft.class_9331;

@Environment(value=EnvType.CLIENT)
public class CoflModClient
implements ClientModInitializer {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    private static boolean keyPressed = false;
    private static int counter = 0;
    public static class_304 bestflipsKeyBinding;
    public static ArrayList<String> knownIds;
    private String username = "";
    private boolean uploadedScoreboard = false;

    public void onInitializeClient() {
        this.username = class_310.method_1551().method_1548().method_1676();
        Path configDir = FabricLoader.getInstance().getConfigDir();
        CoflCore cofl = new CoflCore();
        cofl.init(configDir);
        cofl.registerEventFile((Object)new EventSubscribers());
        ClientLifecycleEvents.CLIENT_STARTED.register(mc -> RenderUtils.init());
        bestflipsKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinding.coflmod.bestflips", class_3675.class_307.field_1668, 66, ""));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (bestflipsKeyBinding.method_1434()) {
                if (counter == 0) {
                    EventRegistry.onOpenBestFlip((String)this.username, (boolean)true);
                }
                if (counter < 2) {
                    ++counter;
                }
            } else {
                counter = 0;
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (class_310.method_1551() != null && class_310.method_1551().method_1558() != null && class_310.method_1551().method_1558().field_3761.contains("hypixel.net")) {
                System.out.println("Connected to Hypixel");
                this.username = class_310.method_1551().method_1548().method_1676();
                if (!CoflCore.Wrapper.isRunning && CoflCore.config.autoStart) {
                    CoflSkyCommand.start((String)this.username);
                }
            }
            this.uploadedScoreboard = false;
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cofl").then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String[] args = ((String)context.getArgument("args", String.class)).split(" ");
            CoflSkyCommand.processCommand((String[])args, (String)this.username);
            return 1;
        }))));
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_476) {
                class_476 gcs = (class_476)screen;
                if (CoflCore.config.purchaseOverlay != null && gcs.method_25440() != null && (gcs.method_25440().getString().contains("BIN Auction View") && ((class_1707)gcs.method_17577()).method_7629().method_5439() == 54 || gcs.method_25440().getString().contains("Confirm Purchase") && ((class_1707)gcs.method_17577()).method_7629().method_5439() == 27) && !(client.field_1755 instanceof CoflBinGUI) && !(client.field_1755 instanceof TfmBinGUI)) {
                    GUIType selector0$temp = CoflCore.config.purchaseOverlay;
                    int index$1 = 0;
                    switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"COFL", "TFM"}, (GUIType)selector0$temp, index$1)) {
                        case 0: {
                            client.method_1507((class_437)new CoflBinGUI(gcs));
                            break;
                        }
                        case 1: {
                            client.method_1507((class_437)new TfmBinGUI(gcs));
                            break;
                        }
                    }
                }
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_465) {
                class_465 hs = (class_465)screen;
                CoflModClient.loadDescriptionsForInv(hs);
                if (!this.uploadedScoreboard) {
                    CoflModClient.uploadScoreboard();
                    CoflModClient.getTabList();
                    this.uploadedScoreboard = true;
                }
            }
        });
        ItemTooltipCallback.EVENT.register((stack, tooltipContext, tooltipType, lines) -> {
            DescriptionHandler.DescModification[] tooltips;
            class_437 patt0$temp;
            if (knownIds.indexOf(CoflModClient.getIdFromStack(stack)) == -1 && (patt0$temp = class_310.method_1551().field_1755) instanceof class_465) {
                class_465 hs = (class_465)patt0$temp;
                CoflModClient.loadDescriptionsForInv(hs);
                return;
            }
            block14: for (DescriptionHandler.DescModification tooltip : tooltips = DescriptionHandler.getTooltipData((String)CoflModClient.getIdFromStack(stack))) {
                switch (tooltip.type) {
                    case "APPEND": {
                        lines.add(class_2561.method_30163((String)(tooltip.value + " ")));
                        continue block14;
                    }
                    case "REPLACE": {
                        lines.remove(tooltip.line);
                        lines.add(tooltip.line, class_2561.method_30163((String)tooltip.value));
                        continue block14;
                    }
                    case "INSERT": {
                        lines.add(tooltip.line, class_2561.method_30163((String)tooltip.value));
                        continue block14;
                    }
                    case "DELETE": {
                        lines.remove(tooltip.line);
                        continue block14;
                    }
                    case "HIGHLIGHT": {
                        class_437 patt1$temp = class_310.method_1551().field_1755;
                        if (!(patt1$temp instanceof class_465)) continue block14;
                        class_465 class_4652 = (class_465)patt1$temp;
                        continue block14;
                    }
                    default: {
                        System.out.println("Unknown type: " + tooltip.type);
                    }
                }
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickCounter) -> {
            if (EventSubscribers.showCountdown && EventSubscribers.countdownData != null && (class_310.method_1551().field_1755 == null || class_310.method_1551().field_1755 instanceof class_408)) {
                RenderUtils.drawStringWithShadow(drawContext, EventSubscribers.countdownData.getPrefix() + "New flips in: " + String.format("%.1f", Float.valueOf(EventSubscribers.countdown)), class_310.method_1551().method_22683().method_4480() / EventSubscribers.countdownData.getWidthPercentage(), class_310.method_1551().method_22683().method_4507() / EventSubscribers.countdownData.getHeightPercentage(), -1, EventSubscribers.countdownData.getScale());
            }
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            EventRegistry.onChatMessage((String)message.getString());
            return true;
        });
    }

    private static void uploadScoreboard() {
        Command data = new Command(CommandType.uploadScoreboard, (Object)CoflModClient.getScoreboard().toArray(new String[0]));
        CoflCore.Wrapper.SendMessage(data);
    }

    public static FlipData popFlipData() {
        FlipData fd = EventSubscribers.flipData;
        EventSubscribers.flipData = null;
        return fd;
    }

    public static class_3414 findByName(String name) {
        class_3414 result = (class_3414)class_3417.field_14793.comp_349();
        for (Field f : class_3417.class.getDeclaredFields()) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            try {
                try {
                    result = (class_3414)f.get(class_3414.class);
                }
                catch (ClassCastException e) {
                    result = (class_3414)((class_6880.class_6883)f.get(class_6880.class_6883.class)).comp_349();
                }
            }
            catch (IllegalAccessException e) {
                System.out.println("SoundEvent inaccessible. This shouldn't happen");
            }
            break;
        }
        return result;
    }

    public static class_2371<class_1799> inventoryToItemStacks(class_1263 inventory) {
        class_2371 itemStacks = class_2371.method_10211();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            itemStacks.add((Object)inventory.method_5438(i));
        }
        return itemStacks;
    }

    public static String inventoryToNBT(class_1263 inventory) {
        return CoflModClient.inventoryToNBT(CoflModClient.inventoryToItemStacks(inventory));
    }

    public static String[] getItemIdsFromInventory(class_1263 inventory) {
        return CoflModClient.getItemIdsFromInventory(CoflModClient.inventoryToItemStacks(inventory));
    }

    public static String inventoryToNBT(class_2371<class_1799> itemStacks) {
        class_2487 nbtCompound = new class_2487();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        class_746 player = class_310.method_1551().field_1724;
        try {
            class_1262.method_5426((class_2487)nbtCompound, itemStacks, (class_7225.class_7874)player.method_56673());
            nbtCompound.method_10566("i", nbtCompound.method_10580("Items"));
            nbtCompound.method_10551("Items");
            class_2507.method_10634((class_2487)nbtCompound, (OutputStream)baos);
            return Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String[] getItemIdsFromInventory(class_2371<class_1799> itemStacks) {
        ArrayList<String> res = new ArrayList<String>();
        knownIds.clear();
        for (int i = 0; i < itemStacks.size(); ++i) {
            class_1799 stack = (class_1799)itemStacks.get(i);
            if (stack.method_7909() == class_1802.field_8162) continue;
            String id = CoflModClient.getIdFromStack(stack);
            knownIds.add(id);
            res.add(id);
        }
        return (String[])res.toArray(String[]::new);
    }

    public static String getIdFromStack(class_1799 stack) {
        JsonObject stackJson = null;
        for (class_9331 type : stack.method_57353().method_57831()) {
            if (!type.toString().contains("minecraft:custom_data")) continue;
            stackJson = (JsonObject)gson.fromJson(stack.method_58694(type).toString(), JsonObject.class);
        }
        if (stackJson == null) {
            return "";
        }
        JsonElement uuid = stackJson.get("uuid");
        if (uuid != null) {
            return uuid.getAsString();
        }
        JsonElement idElement = stackJson.get("id");
        if (idElement != null) {
            return idElement.getAsString() + ";" + stack.method_7947();
        }
        return stack.method_7909().method_63680().getString() + ";" + stack.method_7947();
    }

    public static void loadDescriptionsForInv(class_465 screen) {
        class_2371 itemStacks = screen.method_17577().method_7602();
        if (!class_310.method_1551().field_1724.method_31548().method_5438(8).method_57353().toString().contains("minecraft:custom_data=>{id:\"SKYBLOCK_MENU\"}")) {
            return;
        }
        DescriptionHandler.emptyTooltipData();
        Thread.startVirtualThread(() -> {
            try {
                DescriptionHandler.loadDescriptionForInventory((String[])CoflModClient.getItemIdsFromInventory((class_2371<class_1799>)itemStacks), (String)screen.method_25440().getString(), (String)CoflModClient.inventoryToNBT((class_2371<class_1799>)itemStacks), (String)class_310.method_1551().method_1548().method_1676());
            }
            catch (Exception e) {
                System.out.println("Failed to load descriptions for inventory: " + e.getMessage() + " " + CoflModClient.inventoryToNBT((class_2371<class_1799>)itemStacks));
            }
        });
    }

    private static List<String> getScoreboard() {
        ObjectArrayList scoreboardAsText = new ObjectArrayList();
        if (class_310.method_1551() == null || class_310.method_1551().field_1687 == null) {
            System.out.println("MinecraftClient or world is null, cannot get scoreboard.");
            return scoreboardAsText;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            System.out.println("Player is null, cannot get scoreboard.");
            return scoreboardAsText;
        }
        class_269 scoreboard = player.method_7327();
        class_266 objective = scoreboard.method_1189((class_8646)class_8646.field_45176.apply(1));
        for (class_9015 scoreHolder : scoreboard.method_1178()) {
            String strLine;
            class_268 team;
            if (!scoreboard.method_1166(scoreHolder).containsKey((Object)objective) || (team = scoreboard.method_1164(scoreHolder.method_5820())) == null || (strLine = team.method_1144().getString() + team.method_1136().getString()).trim().isEmpty()) continue;
            String formatted = class_124.method_539((String)strLine);
            scoreboardAsText.add((Object)formatted);
        }
        if (objective != null) {
            scoreboardAsText.add((Object)objective.method_1114().getString());
            Collections.reverse(scoreboardAsText);
        }
        return scoreboardAsText;
    }

    private static List<String> getTabList() {
        ArrayList<String> tabList = new ArrayList<String>();
        if (class_310.method_1551() == null || class_310.method_1551().field_1687 == null) {
            System.out.println("MinecraftClient or world is null, cannot get tab list.");
            return tabList;
        }
        class_310 client = class_310.method_1551();
        class_634 networkHandler = client.method_1562();
        if (networkHandler != null) {
            for (class_640 playerListEntry : networkHandler.method_2880()) {
                if (playerListEntry == null) continue;
                if (playerListEntry.method_2971() != null) {
                    String displayName = playerListEntry.method_2971().getString();
                    System.out.println(displayName);
                    tabList.add(displayName);
                    continue;
                }
                String playerName = playerListEntry.method_2966().getName();
                tabList.add(playerName);
            }
        }
        return tabList;
    }

    static {
        knownIds = new ArrayList();
    }
}

