/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky.network;

import com.neovisionaries.ws.client.WebSocketException;
import de.torui.coflsky.commands.Command;
import de.torui.coflsky.commands.RawCommand;
import de.torui.coflsky.minecraft_integration.CoflSessionManager;
import de.torui.coflsky.minecraft_integration.PlayerDataProvider;
import de.torui.coflsky.network.WSClient;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import net.minecraft.client.Minecraft;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class WSClientWrapper {
    public WSClient socket;
    public boolean isRunning;
    public boolean isStarting;
    private String[] uris;

    public WSClientWrapper(String[] uris) {
        this.uris = uris;
    }

    public void restartWebsocketConnection() {
        this.socket.stop();
        System.out.println("Sleeping...");
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Lost connection to Coflnet, trying to reestablish the connection in 2 Seconds..."));
        this.socket = new WSClient(this.socket.uri);
        this.isRunning = false;
        while (!this.isRunning) {
            this.start();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.socket.shouldRun = true;
    }

    public boolean startConnection() {
        if (this.isRunning || this.isStarting) {
            return false;
        }
        for (String s : this.uris) {
            System.out.println("Trying connection with uri=" + s);
            if (!this.initializeNewSocket(s)) continue;
            return true;
        }
        Minecraft.func_71410_x().field_71439_g.func_145747_a(new ChatComponentText("Cofl could not establish a connection to any server!\nIf you use a vpn/proxy please try connecting without it.\nIf that does not work please contact us on our ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)).func_150257_a(new ChatComponentText("discord!").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.BLUE).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/wvKXfTgCfb")))));
        return false;
    }

    public boolean initializeNewSocket(String uriPrefix) {
        String uri = uriPrefix;
        uri = uri + "?version=1.5.5-Alpha";
        String username = PlayerDataProvider.getUsername();
        uri = uri + "&player=" + username;
        try {
            CoflSessionManager.UpdateCoflSessions();
            String coflSessionID = CoflSessionManager.GetCoflSession((String)username).SessionUUID;
            uri = uri + "&SId=" + coflSessionID;
            if (this.socket != null) {
                this.socket.stop();
            }
            this.socket = new WSClient(URI.create(uri));
            this.isRunning = false;
            boolean successfull = this.start();
            if (successfull) {
                this.socket.shouldRun = true;
            }
            return successfull;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private synchronized boolean start() {
        if (!this.isRunning && !this.isStarting) {
            try {
                this.isStarting = true;
                this.socket.start();
                this.isRunning = true;
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (WebSocketException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            finally {
                this.isStarting = false;
            }
            return false;
        }
        return false;
    }

    public synchronized void stop() {
        if (this.isRunning) {
            this.socket.shouldRun = false;
            this.socket.stop();
            this.isRunning = false;
            this.socket = null;
        }
    }

    public synchronized void SendMessage(RawCommand cmd) {
        if (this.isRunning) {
            this.socket.SendCommand(cmd);
        } else {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("tried sending a callback to coflnet but failed. the connection must be closed."));
        }
    }

    public synchronized void SendMessage(Command cmd) {
        if (this.isRunning) {
            this.socket.SendCommand(cmd);
        } else {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("tried sending a callback to coflnet but failed. the connection must be closed."));
        }
    }

    public String GetStatus() {
        return "" + this.isRunning + " " + (this.socket != null ? this.socket.currentState.toString() : "NOT_INITIALIZED");
    }
}

