/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.torui.coflsky.CoflSky;
import de.torui.coflsky.CountdownTimer;
import de.torui.coflsky.FlipHandler;
import de.torui.coflsky.commands.Command;
import de.torui.coflsky.commands.CommandType;
import de.torui.coflsky.commands.JsonStringCommand;
import de.torui.coflsky.commands.RawCommand;
import de.torui.coflsky.commands.models.ChatMessageData;
import de.torui.coflsky.commands.models.FlipData;
import de.torui.coflsky.commands.models.ModListData;
import de.torui.coflsky.commands.models.ProxyRequest;
import de.torui.coflsky.commands.models.SoundData;
import de.torui.coflsky.commands.models.TimerData;
import de.torui.coflsky.configuration.ConfigurationManager;
import de.torui.coflsky.handlers.EventRegistry;
import de.torui.coflsky.proxy.ProxyManager;
import de.torui.coflsky.utils.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class WSCommandHandler {
    public static transient String lastOnClickEvent;
    public static FlipHandler flipHandler;
    private static final ModListData modListData;
    private static final Gson gson;
    private static final ProxyManager proxyManager;

    public static boolean HandleCommand(JsonStringCommand cmd, Entity sender) {
        System.out.println("Handling Command=" + cmd.toString());
        switch (cmd.getType()) {
            case WriteToChat: {
                WSCommandHandler.WriteToChat(cmd.GetAs(new TypeToken<ChatMessageData>(){}));
                break;
            }
            case Execute: {
                WSCommandHandler.Execute(cmd.GetAs(new TypeToken<String>(){}), sender);
                break;
            }
            case PlaySound: {
                SoundData sc = cmd.GetAs(new TypeToken<SoundData>(){}).getData();
                WSCommandHandler.PlaySound(sc.Name, sc.Pitch);
                break;
            }
            case ChatMessage: {
                WSCommandHandler.ChatMessage(cmd.GetAs(new TypeToken<ChatMessageData[]>(){}));
                break;
            }
            case Flip: {
                WSCommandHandler.Flip(cmd.GetAs(new TypeToken<FlipData>(){}));
                break;
            }
            case PrivacySettings: {
                new ConfigurationManager().UpdateConfiguration((String)cmd.getData());
            }
            case Countdown: {
                WSCommandHandler.StartTimer(cmd.GetAs(new TypeToken<TimerData>(){}));
                break;
            }
            case GetMods: {
                WSCommandHandler.getMods();
                break;
            }
            case ProxyRequest: {
                WSCommandHandler.handleProxyRequest(cmd.GetAs(new TypeToken<ProxyRequest[]>(){}).getData());
                break;
            }
        }
        return true;
    }

    private static void Flip(Command<FlipData> cmd) {
        ChatMessageData[] messages = cmd.getData().Messages;
        SoundData sound = cmd.getData().Sound;
        if (sound != null && sound.Name != null) {
            WSCommandHandler.PlaySound(sound.Name, sound.Pitch);
        }
        Command<ChatMessageData[]> showCmd = new Command<ChatMessageData[]>(CommandType.ChatMessage, messages);
        WSCommandHandler.ChatMessage(showCmd);
        WSCommandHandler.flipHandler.fds.Insert(cmd.getData());
        EventRegistry.onAfterKeyPressed();
    }

    private static void handleProxyRequest(ProxyRequest[] request) {
        for (ProxyRequest req : request) {
            proxyManager.handleRequestAsync(req);
        }
    }

    public static void cacheMods() {
        File modFolder = new File(Minecraft.func_71410_x().field_71412_D, "mods");
        for (File mods : modFolder.listFiles()) {
            modListData.addFilename(mods.getName());
            try {
                modListData.addFileHashes(FileUtils.getMD5Checksum(mods));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (ModContainer mod : Loader.instance().getModList()) {
            modListData.addModname(mod.getName());
            modListData.addModname(mod.getModId());
        }
    }

    private static void getMods() {
        CoflSky.Wrapper.SendMessage(new RawCommand("foundMods", gson.toJson((Object)modListData)));
    }

    private static void PlaySound(String soundName, float pitch) {
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        PositionedSoundRecord psr = PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(soundName), (float)pitch);
        handler.func_147682_a((ISound)psr);
    }

    private static void Execute(Command<String> cmd, Entity sender) {
        System.out.println("Execute: " + cmd.getData() + " sender:" + sender);
        WSCommandHandler.Execute(cmd.getData(), sender);
    }

    private static void StartTimer(Command<TimerData> cmd) {
        CountdownTimer.startCountdown(cmd.getData());
    }

    public static void Execute(String cmd, Entity sender) {
        if (cmd.startsWith("/cofl") || cmd.startsWith("http")) {
            ClientCommandHandler.instance.func_71556_a((ICommandSender)sender, cmd);
        } else {
            Minecraft.func_71410_x().field_71439_g.func_71165_d(cmd);
        }
    }

    private static IChatComponent CommandToChatComponent(ChatMessageData wcmd, String fullMessage) {
        if (wcmd.OnClick != null) {
            lastOnClickEvent = wcmd.Text != null && wcmd.OnClick.startsWith("/viewauction") ? "/cofl openauctiongui " + wcmd.OnClick.split(" ")[1] + " false" : "/cofl callback " + wcmd.OnClick;
        }
        if (wcmd.Text != null) {
            ChatComponentText comp = new ChatComponentText(wcmd.Text);
            if (wcmd.OnClick != null) {
                ChatStyle style = wcmd.OnClick.startsWith("http") ? new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, wcmd.OnClick)) : new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, lastOnClickEvent));
                comp.func_150255_a(style);
            }
            if (wcmd.Hover != null && !wcmd.Hover.isEmpty()) {
                if (comp.func_150256_b() == null) {
                    comp.func_150255_a(new ChatStyle());
                }
                comp.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(wcmd.Hover)));
            }
            return comp;
        }
        return null;
    }

    public static void sendChatMessage(IChatComponent message) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a(message);
    }

    public static IChatComponent ChatMessage(Command<ChatMessageData[]> cmd) {
        ChatMessageData[] list = cmd.getData();
        ChatComponentText master = new ChatComponentText("");
        String fullMessage = WSCommandHandler.ChatMessageDataToString(list);
        for (ChatMessageData wcmd : list) {
            IChatComponent comp = WSCommandHandler.CommandToChatComponent(wcmd, fullMessage);
            if (comp == null) continue;
            master.func_150257_a(comp);
        }
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)master);
        return master;
    }

    private static void WriteToChat(Command<ChatMessageData> cmd) {
        ChatMessageData wcmd = cmd.getData();
        IChatComponent comp = WSCommandHandler.CommandToChatComponent(wcmd, wcmd.Text);
        if (comp != null) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a(comp);
        }
    }

    public static String ChatMessageDataToString(ChatMessageData[] messages) {
        Stream<String> stream = Arrays.stream(messages).map(message -> message.Text);
        String s = String.join((CharSequence)",", (CharSequence[])stream.toArray(String[]::new));
        stream.close();
        return s;
    }

    static {
        flipHandler = new FlipHandler();
        modListData = new ModListData();
        gson = new Gson();
        proxyManager = new ProxyManager();
    }
}

