/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky;

import de.torui.coflsky.CoflSky;
import de.torui.coflsky.Config;
import de.torui.coflsky.WSCommandHandler;
import de.torui.coflsky.commands.Command;
import de.torui.coflsky.commands.CommandType;
import de.torui.coflsky.commands.JsonStringCommand;
import de.torui.coflsky.commands.RawCommand;
import de.torui.coflsky.commands.models.FlipData;
import de.torui.coflsky.gui.GUIType;
import de.torui.coflsky.gui.bingui.BinGuiManager;
import de.torui.coflsky.gui.tfm.ButtonRemapper;
import de.torui.coflsky.minecraft_integration.CoflSessionManager;
import de.torui.coflsky.minecraft_integration.PlayerDataProvider;
import de.torui.coflsky.network.QueryServerCommands;
import de.torui.coflsky.network.WSClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;

public class CoflSkyCommand
extends CommandBase {
    public static final String HelpText = "Available local sub-commands:\n\u00a7bstart: \u00a77starts a new connection\n\u00a7bstop: \u00a77stops the connection\n\u00a7bconnect: \u00a77Connects to a different server\n\u00a7breset: \u00a77resets all local session information and stops the connection\n\u00a7bstatus: \u00a77Emits status information\n\u00a7bsetgui: \u00a77Changes the auction purchase GUI\nServer-Only Commands:";

    public int func_82362_a() {
        return 0;
    }

    public String func_71517_b() {
        return "cofl";
    }

    public List func_71514_a() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("Cofl");
        al.add("coflnet");
        al.add("cl");
        return al;
    }

    public String func_71518_a(ICommandSender sender) {
        return HelpText;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        new Thread(() -> {
            block36: {
                block35: {
                    System.out.println(Arrays.toString(args));
                    if (args.length < 1) break block35;
                    switch (args[0].toLowerCase()) {
                        case "start": {
                            CoflSky.Wrapper.stop();
                            sender.func_145747_a((IChatComponent)new ChatComponentText("starting connection..."));
                            CoflSky.Wrapper.startConnection();
                            break;
                        }
                        case "stop": {
                            CoflSky.Wrapper.stop();
                            sender.func_145747_a(new ChatComponentText("you stopped the connection to ").func_150257_a(new ChatComponentText("C").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_BLUE))).func_150257_a(new ChatComponentText("oflnet").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD))).func_150257_a((IChatComponent)new ChatComponentText(".\n    To reconnect enter ")).func_150257_a(new ChatComponentText("\"").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.AQUA))).func_150257_a((IChatComponent)new ChatComponentText("/cofl start")).func_150257_a(new ChatComponentText("\"").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.AQUA))).func_150257_a((IChatComponent)new ChatComponentText(" or click this message")).func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/cofl start"))));
                            break;
                        }
                        case "debug": {
                            break;
                        }
                        case "callback": {
                            this.CallbackCommand(args);
                            break;
                        }
                        case "dev": {
                            if (Config.BaseUrl.contains("localhost")) {
                                CoflSky.Wrapper.startConnection();
                                Config.BaseUrl = "https://sky.coflnet.com";
                            } else {
                                CoflSky.Wrapper.initializeNewSocket("ws://localhost:8009/modsocket");
                                Config.BaseUrl = "http://localhost:5005";
                            }
                            sender.func_145747_a((IChatComponent)new ChatComponentText("toggled dev mode, now using " + Config.BaseUrl));
                            break;
                        }
                        case "status": {
                            sender.func_145747_a((IChatComponent)new ChatComponentText(this.StatusMessage()));
                            break;
                        }
                        case "reset": {
                            this.HandleReset();
                            break;
                        }
                        case "connect": {
                            if (args.length == 2) {
                                String destination = args[1];
                                if (!destination.contains("://")) {
                                    destination = new String(Base64.getDecoder().decode(destination));
                                }
                                sender.func_145747_a((IChatComponent)new ChatComponentText("Stopping connection!"));
                                CoflSky.Wrapper.stop();
                                sender.func_145747_a((IChatComponent)new ChatComponentText("Opening connection to " + destination));
                                if (CoflSky.Wrapper.initializeNewSocket(destination)) {
                                    sender.func_145747_a((IChatComponent)new ChatComponentText("Success"));
                                    break;
                                }
                                sender.func_145747_a((IChatComponent)new ChatComponentText("Could not open connection, please check the logs"));
                                break;
                            }
                            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cPleace specify a server to connect to"));
                            break;
                        }
                        case "openauctiongui": {
                            boolean shouldInvalidate;
                            FlipData flip = WSCommandHandler.flipHandler.fds.getFlipById(args[1]);
                            boolean bl = shouldInvalidate = args.length >= 3 && args[2].equals("true");
                            if (flip == null) {
                                WSCommandHandler.flipHandler.lastClickedFlipMessage = "";
                                Minecraft.func_71410_x().field_71439_g.func_71165_d("/viewauction " + args[1]);
                                return;
                            }
                            String oneLineMessage = String.join((CharSequence)" ", flip.getMessageAsString()).replaceAll("\n", "").split(",\u00a77 sellers ah")[0];
                            if (shouldInvalidate) {
                                WSCommandHandler.flipHandler.fds.InvalidateFlip(flip);
                            }
                            WSCommandHandler.flipHandler.lastClickedFlipMessage = oneLineMessage;
                            BinGuiManager.openNewFlipGui(oneLineMessage, flip.Render);
                            Minecraft.func_71410_x().field_71439_g.func_71165_d("/viewauction " + flip.Id);
                            break;
                        }
                        case "setgui": {
                            if (args.length != 2) {
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Available GUIs:"));
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Cofl"));
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77TFM"));
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Off"));
                                return;
                            }
                            if (args[1].equalsIgnoreCase("cofl")) {
                                CoflSky.config.purchaseOverlay = GUIType.COFL;
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bPurchase Overlay \u00a77to: \u00a7fCofl"));
                                MinecraftForge.EVENT_BUS.unregister((Object)ButtonRemapper.getInstance());
                            }
                            if (args[1].equalsIgnoreCase("tfm")) {
                                CoflSky.config.purchaseOverlay = GUIType.TFM;
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bPurchase Overlay \u00a77to: \u00a7fTFM"));
                                MinecraftForge.EVENT_BUS.register((Object)ButtonRemapper.getInstance());
                            }
                            if (args[1].equalsIgnoreCase("off") || args[1].equalsIgnoreCase("false")) {
                                CoflSky.config.purchaseOverlay = null;
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bPurchase Overlay \u00a77to: \u00a7fOff"));
                                MinecraftForge.EVENT_BUS.unregister((Object)ButtonRemapper.getInstance());
                                break;
                            }
                            break block36;
                        }
                        default: {
                            this.SendCommandToServer(args, sender);
                        }
                    }
                    break block36;
                }
                this.ListHelp(sender);
            }
        }).start();
    }

    private void HandleReset() {
        CoflSky.Wrapper.SendMessage(new Command<String>(CommandType.Reset, ""));
        CoflSky.Wrapper.stop();
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Stopping Connection to SkyCofl"));
        CoflSessionManager.DeleteAllCoflSessions();
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Deleting SkyCofl sessions..."));
        if (CoflSky.Wrapper.startConnection()) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Started the Connection to SkyCofl"));
        }
    }

    public String StatusMessage() {
        String vendor = System.getProperty("java.vm.vendor");
        String name = System.getProperty("java.vm.name");
        String version = System.getProperty("java.version");
        String detailedVersion = System.getProperty("java.vm.version");
        String status = vendor + " " + name + " " + version + " " + detailedVersion + "|Connection = " + (CoflSky.Wrapper != null ? CoflSky.Wrapper.GetStatus() : "UNINITIALIZED_WRAPPER");
        try {
            status = status + "  uri=" + CoflSky.Wrapper.socket.uri.toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            CoflSessionManager.CoflSession session = CoflSessionManager.GetCoflSession(PlayerDataProvider.getUsername());
            String sessionString = CoflSessionManager.gson.toJson((Object)session);
            status = status + "  session=" + sessionString;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    public void SendCommandToServer(String[] args, ICommandSender sender) {
        String command = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        RawCommand rc = new RawCommand(args[0], WSClient.gson.toJson((Object)command));
        if (CoflSky.Wrapper.isRunning) {
            CoflSky.Wrapper.SendMessage(rc);
        } else {
            CoflSkyCommand.SendAfterStart(sender, rc);
        }
    }

    private static synchronized void SendAfterStart(ICommandSender sender, RawCommand rc) {
        sender.func_145747_a(new ChatComponentText("CoflSky wasn't active.").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
        CoflSky.Wrapper.startConnection();
        CoflSky.Wrapper.SendMessage(rc);
    }

    public void ListHelp(ICommandSender sender) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(HelpText));
        sender.func_145747_a((IChatComponent)new ChatComponentText(QueryServerCommands.QueryCommands()));
    }

    public void CallbackCommand(String[] args) {
        String command = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        System.out.println("CallbackData: " + command);
        System.out.println("Callback: " + command);
        WSCommandHandler.HandleCommand(new JsonStringCommand(CommandType.Execute, WSClient.gson.toJson((Object)command)), (Entity)Minecraft.func_71410_x().field_71439_g);
        CoflSky.Wrapper.SendMessage(new JsonStringCommand(CommandType.Clicked, WSClient.gson.toJson((Object)command)));
        System.out.println("Sent!");
    }
}

