/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky.handlers;

import de.torui.coflsky.Config;
import de.torui.coflsky.network.QueryServerCommands;
import de.torui.coflsky.network.WSClient;
import de.torui.coflsky.utils.ReflectionUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class DescriptionHandler {
    public static String allItemIds;
    public static HashMap<String, DescModification[]> tooltipItemIdMap;
    public static final DescModification[] EMPTY_ARRAY;
    public static final NBTTagCompound EMPTY_COMPOUND;
    private boolean IsOpen = true;
    private boolean shouldUpdate = false;
    public static MethodHandle xSizeField;
    public static MethodHandle ySizeField;

    public void Close() {
        this.IsOpen = false;
    }

    public static String ExtractStackableIdFromItemStack(ItemStack stack) {
        if (stack != null) {
            try {
                NBTTagCompound serialized = stack.serializeNBT();
                String itemTag = serialized.func_74775_l("tag").func_74775_l("ExtraAttributes").func_74779_i("id");
                if (itemTag != null && itemTag.length() > 1) {
                    return itemTag + ":" + stack.field_77994_a;
                }
                return serialized.func_74775_l("tag").func_74775_l("display").func_74779_i("Name");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static String ExtractIdFromItemStack(ItemStack stack) {
        if (stack != null) {
            try {
                String uuid = stack.serializeNBT().func_74775_l("tag").func_74775_l("ExtraAttributes").func_74779_i("uuid");
                if (uuid.length() == 0) {
                    throw new Exception();
                }
                return uuid;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DescriptionHandler.ExtractStackableIdFromItemStack(stack);
    }

    private DescModification[] getTooltipData(ItemStack itemStack) {
        String id = DescriptionHandler.ExtractIdFromItemStack(itemStack);
        if (tooltipItemIdMap.containsKey(id)) {
            return tooltipItemIdMap.getOrDefault(id, EMPTY_ARRAY);
        }
        this.shouldUpdate = true;
        return EMPTY_ARRAY;
    }

    public void loadDescriptionAndListenForChanges(GuiOpenEvent event) {
        GuiContainer gc = (GuiContainer)event.gui;
        this.shouldUpdate = DescriptionHandler.loadDescriptionForInventory(event, gc, false);
        int iteration = 1;
        while (this.IsOpen) {
            try {
                Thread.sleep(300 * iteration++);
                ++iteration;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (this.shouldUpdate || DescriptionHandler.hasAnyStackChanged(gc)) {
                this.shouldUpdate = DescriptionHandler.loadDescriptionForInventory(event, gc, true);
                iteration = 5;
            }
            if (iteration < 30) continue;
            iteration = 29;
        }
    }

    private static boolean hasAnyStackChanged(GuiContainer gc) {
        return !allItemIds.equals(DescriptionHandler.getCurrentInventoryIds(gc));
    }

    private static String getCurrentInventoryIds(GuiContainer gc) {
        StringBuilder builder = new StringBuilder();
        for (Slot obj : gc.field_147002_h.field_75151_b) {
            ItemStack stack = obj.func_75211_c();
            String id = DescriptionHandler.ExtractIdFromItemStack(stack);
            builder.append(id);
        }
        return builder.toString();
    }

    private static boolean loadDescriptionForInventory(GuiOpenEvent event, GuiContainer gc, boolean skipLoadCheck) {
        InventoryWrapper wrapper = new InventoryWrapper();
        if (event.gui instanceof GuiChest) {
            ContainerChest chest;
            IInventory inv;
            if (!skipLoadCheck) {
                DescriptionHandler.waitForChestContentLoad(event, gc);
            }
            if ((inv = (chest = (ContainerChest)((GuiChest)event.gui).field_147002_h).func_85151_d()).func_145818_k_()) {
                Object chestName;
                wrapper.chestName = chestName = inv.func_70005_c_();
            }
        }
        allItemIds = DescriptionHandler.getCurrentInventoryIds(gc);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList tl = new NBTTagList();
        for (Slot obj : gc.field_147002_h.field_75151_b) {
            ItemStack stack = obj.func_75211_c();
            if (stack != null) {
                tl.func_74742_a((NBTBase)stack.serializeNBT());
                continue;
            }
            tl.func_74742_a((NBTBase)EMPTY_COMPOUND);
        }
        boolean shouldGetRefreshed = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            compound.func_74782_a("i", (NBTBase)tl);
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)baos);
            wrapper.fullInventoryNbt = Base64.getEncoder().encodeToString(baos.toByteArray());
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (Slot obj : gc.field_147002_h.field_75151_b) {
                stacks.add(obj.func_75211_c());
            }
            String data = WSClient.gson.toJson((Object)wrapper);
            String info = QueryServerCommands.PostRequest(Config.BaseUrl + "/api/mod/description/modifications", data);
            DescModification[][] arr = (DescModification[][])WSClient.gson.fromJson(info, DescModification[][].class);
            for (int i = 0; i < stacks.size(); ++i) {
                ItemStack stack = (ItemStack)stacks.get(i);
                String id = DescriptionHandler.ExtractIdFromItemStack(stack);
                if (id.length() > 0) {
                    tooltipItemIdMap.put(id, arr[i]);
                }
                if (stack == null) continue;
                NBTTagList lore = stack.func_77978_p().func_74775_l("display").func_150295_c("Lore", 8);
                for (int j = 0; j < lore.func_74745_c(); ++j) {
                    String tag = lore.func_179238_g(j).toString();
                    if (!tag.contains("\u00a77Refreshing...")) continue;
                    shouldGetRefreshed = true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return shouldGetRefreshed;
    }

    private static void waitForChestContentLoad(GuiOpenEvent event, GuiContainer gc) {
        for (int i = 1; i < 10 && ((Slot)gc.field_147002_h.field_75151_b.get(gc.field_147002_h.field_75151_b.size() - 37)).func_75211_c() == null; ++i) {
            try {
                Thread.sleep(20 * i);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setTooltips(ItemTooltipEvent event) {
        DescModification[] data = this.getTooltipData(event.itemStack);
        if (data == null || data.length == 0) {
            return;
        }
        block12: for (DescModification datum : data) {
            if (event.toolTip.size() <= datum.line) {
                System.out.println("Skipped line modification " + datum.line + " for " + event.itemStack.func_82833_r());
                continue;
            }
            switch (datum.type) {
                case "APPEND": {
                    event.toolTip.add(datum.value);
                    continue block12;
                }
                case "REPLACE": {
                    event.toolTip.set(datum.line, datum.value);
                    continue block12;
                }
                case "INSERT": {
                    event.toolTip.add(datum.line, datum.value);
                    continue block12;
                }
                case "DELETE": {
                    event.toolTip.remove(datum.line);
                }
            }
        }
    }

    public void highlightSlots(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (!(event.gui instanceof GuiContainer)) {
            return;
        }
        GuiContainer containerGui = (GuiContainer)event.gui;
        for (Slot inventorySlot : containerGui.field_147002_h.field_75151_b) {
            DescModification[] tooltipData;
            if (!inventorySlot.func_75216_d()) continue;
            for (DescModification modification : tooltipData = this.getTooltipData(inventorySlot.func_75211_c())) {
                if (!"HIGHLIGHT".equals(modification.type)) continue;
                int color = (int)(Long.parseLong(modification.value, 16) & 0xFFFFFFFFL);
                try {
                    int guiTop = (containerGui.field_146295_m - ySizeField.invokeExact(containerGui)) / 2;
                    int guiLeft = (containerGui.field_146294_l - xSizeField.invokeExact(containerGui)) / 2;
                    int slotX = inventorySlot.field_75223_e + guiLeft;
                    int slotY = inventorySlot.field_75221_f + guiTop;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
                    Gui.func_73734_a((int)slotX, (int)slotY, (int)(slotX + 16), (int)(slotY + 16), (int)(modification.value.length() > 6 ? color : color | 0xFF000000));
                    GlStateManager.func_179121_F();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void emptyTooltipData() {
        tooltipItemIdMap.clear();
    }

    static {
        tooltipItemIdMap = new HashMap();
        EMPTY_ARRAY = new DescModification[0];
        EMPTY_COMPOUND = new NBTTagCompound();
        xSizeField = ReflectionUtil.getField(GuiContainer.class, "xSize", "field_146999_f", "f");
        ySizeField = ReflectionUtil.getField(GuiContainer.class, "ySize", "field_147000_g", "g");
    }

    private static class DescModification {
        public String type;
        public String value;
        public int line;

        private DescModification() {
        }
    }

    private static class InventoryWrapper {
        public String chestName;
        public String fullInventoryNbt;

        private InventoryWrapper() {
        }
    }
}

