/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky.gui.bingui;

import de.torui.coflsky.CoflSky;
import de.torui.coflsky.gui.GUIType;
import de.torui.coflsky.gui.bingui.BuyState;
import de.torui.coflsky.gui.bingui.helper.ColorPallet;
import de.torui.coflsky.gui.bingui.helper.RenderUtils;
import de.torui.coflsky.handlers.EventHandler;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;

public class BinGuiCurrent
extends GuiChest {
    private String message;
    private String[] lore;
    private ItemStack itemStack;
    private String buyText = "Buy(You can click anywhere)";
    private BuyState buyState = BuyState.INIT;
    private int pixelsScrolled = 0;
    private boolean wasMouseDown;
    private boolean isRendered = false;
    private boolean isClosing = false;
    private boolean hasInitialMouseSet = false;
    private String buyer = null;
    private static final Pattern CAN_BUY_IN_MATCHER = Pattern.compile("Can buy in: (.*)");
    private static final Pattern BUYER_MATCHER = Pattern.compile("Buyer: (.*)");
    private GuiChest chestGui;

    public BinGuiCurrent(IInventory playerInventory, IInventory chestInventory, String message, String extraData) {
        super(playerInventory, chestInventory);
        this.message = message;
        this.lore = new String[]{"Loading..."};
        if (extraData.length() >= 32) {
            this.itemStack = BinGuiCurrent.getSkull("Name", "00000000-0000-0000-0000-000000000000", extraData);
        } else {
            this.itemStack = new ItemStack(BinGuiCurrent.getItemByText(extraData));
            if (this.itemStack.func_77973_b() == null) {
                return;
            }
            if (this.itemStack.func_77973_b() instanceof ItemArmor && (this.itemStack.func_77973_b() == Items.field_151024_Q || this.itemStack.func_77973_b() == Items.field_151027_R || this.itemStack.func_77973_b() == Items.field_151026_S || this.itemStack.func_77973_b() == Items.field_151021_T)) {
                ((ItemArmor)this.itemStack.func_77973_b()).func_82813_b(this.itemStack, 0);
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private boolean shouldSkip(GuiScreen screen) {
        return !(screen instanceof GuiChest) || CoflSky.config.purchaseOverlay != GUIType.COFL || !EventHandler.isInSkyblock;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui == null) {
            return;
        }
        this.isRendered = false;
        GuiScreen gui = event.gui;
        if (this.message == null || this.message.isEmpty()) {
            return;
        }
        if (this.shouldSkip(gui)) {
            return;
        }
        GuiChest chest = (GuiChest)gui;
        IInventory inventory = ((ContainerChest)chest.field_147002_h).func_85151_d();
        if (inventory == null) {
            return;
        }
        String guiName = inventory.func_145748_c_().func_150260_c().trim();
        if (guiName.equalsIgnoreCase("BIN Auction View") || guiName.equalsIgnoreCase("Confirm Purchase")) {
            this.chestGui = (GuiChest)event.gui;
            this.field_147002_h = ((GuiChest)event.gui).field_147002_h;
            event.gui = this;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrawGuiScreen(GuiScreenEvent.DrawScreenEvent.Pre event) {
        this.isRendered = false;
        GuiScreen gui = event.gui;
        if (this.message == null || this.message.isEmpty()) {
            return;
        }
        if (this.shouldSkip(gui)) {
            return;
        }
        GuiChest chest = (GuiChest)gui;
        IInventory inventory = ((ContainerChest)chest.field_147002_h).func_85151_d();
        if (inventory == null) {
            return;
        }
        String guiName = inventory.func_145748_c_().func_150260_c().trim();
        if (guiName.equalsIgnoreCase("auction view")) {
            return;
        }
        ItemStack item = inventory.func_70301_a(13);
        if (item == null) {
            return;
        }
        String[] tooltip = item.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, false).toArray(new String[0]);
        this.itemStack = item;
        if (guiName.equalsIgnoreCase("BIN Auction View")) {
            this.lore = tooltip;
            this.buyer = this.isAlreadyBought(tooltip);
        }
        if (guiName.equalsIgnoreCase("BIN Auction View") && this.buyState == BuyState.PURCHASE) {
            if (this.waitingForBed(chest)) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a7cBed is not purchasable yet."));
                this.buyState = BuyState.INIT;
            } else {
                this.field_146297_k.field_71442_b.func_78753_a(this.chestGui.field_147002_h.field_75152_c, 31, 2, 3, (EntityPlayer)this.field_146297_k.field_71439_g);
                this.wasMouseDown = false;
                this.buyState = BuyState.CONFIRM;
            }
        } else if (guiName.equalsIgnoreCase("Confirm Purchase") && this.buyState == BuyState.BUYING) {
            this.field_146297_k.field_71442_b.func_78753_a(this.chestGui.field_147002_h.field_75152_c, 11, 2, 3, (EntityPlayer)this.field_146297_k.field_71439_g);
            this.resetGUI();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.isClosing) {
            return;
        }
        Mouse.setGrabbed((boolean)false);
        this.isRendered = true;
        int screenWidth = this.field_146294_l;
        int screenHeight = this.field_146295_m;
        int width = this.field_146297_k.field_71466_p.func_78256_a(this.message) > 500 ? this.field_146297_k.field_71466_p.func_78256_a(this.message) + 5 : 500;
        int height = 300;
        if (!this.hasInitialMouseSet) {
            Mouse.setCursorPosition((int)(this.field_146297_k.field_71443_c / 2), (int)(this.field_146297_k.field_71440_d / 2));
            this.hasInitialMouseSet = true;
        }
        RenderUtils.drawRoundedRect(screenWidth / 2 - width / 2, 10, width, height, 10, ColorPallet.PRIMARY.getColor());
        RenderUtils.drawRoundedRect(screenWidth / 2 - width / 2 + 5, 15, width - 10, 14, 5, ColorPallet.SECONDARY.getColor());
        RenderUtils.drawString(this.message, screenWidth / 2 - width / 2 + 7, 18, ColorPallet.WHITE.getColor());
        RenderUtils.drawRoundedRect(screenWidth / 2 - width / 2 + 5, 34, 20, 20, 5, ColorPallet.TERTIARY.getColor());
        if (this.itemStack == null) {
            RenderUtils.drawString("?", screenWidth / 2 - width / 2 + 5 + 5, 36, ColorPallet.WHITE.getColor(), 40);
        } else {
            RenderUtils.drawItemStack(this.itemStack, screenWidth / 2 - width / 2 + 5 + 2, 36);
        }
        RenderUtils.drawRoundedRect(screenWidth / 2 - width / 2 + 5 + 20 + 5, 34, width - 10 - 25, height - 100, 5, ColorPallet.SECONDARY.getColor());
        int y = 36;
        for (int i = 0; i < this.lore.length; ++i) {
            if (y + this.pixelsScrolled > 34 && y + this.pixelsScrolled < 34 + (height - 100)) {
                RenderUtils.drawString(this.lore[i], screenWidth / 2 - width / 2 + 5 + 20 + 5 + 2, y + this.pixelsScrolled, ColorPallet.WHITE.getColor());
            }
            y += 10;
        }
        RenderUtils.drawRoundedRect(screenWidth / 2 - width / 2 + 5, 34 + (height - 100) + 5, (width - 10) / 2 - 25, 60, 5, ColorPallet.ERROR.getColor());
        RenderUtils.drawString("Cancel", screenWidth / 2 - width / 2 + 5 + 5, 34 + (height - 100) + 5 + 5, ColorPallet.WHITE.getColor(), 40);
        if (BinGuiCurrent.isMouseOverCancel(mouseX, mouseY, screenWidth, screenHeight, width, height)) {
            RenderUtils.drawRoundedRect(screenWidth / 2 - width / 2 + 5, 34 + (height - 100) + 5, (width - 10) / 2 - 25, 60, 5, RenderUtils.setAlpha(ColorPallet.WHITE.getColor(), 100));
            RenderUtils.drawString("Cancel", screenWidth / 2 - width / 2 + 5 + 5, 34 + (height - 100) + 5 + 5, ColorPallet.WHITE.getColor(), 40);
            if (this.isClicked()) {
                this.field_146297_k.field_71439_g.func_85030_a("random.anvil_land", 1.0f, 1.0f);
                this.resetGUI();
            }
        }
        if (this.buyer == null) {
            RenderUtils.drawRoundedRect(screenWidth / 2 - width / 2 + 5 + (width - 10) / 2 - 20, 34 + (height - 100) + 5, (width - 10) / 2 + 20, 60, 5, ColorPallet.SUCCESS.getColor());
            RenderUtils.drawString(this.buyText, screenWidth / 2 - width / 2 + 5 + (width - 10) / 2 + 5 - 20, 34 + (height - 100) + 5 + 5, ColorPallet.WHITE.getColor(), 40);
        } else {
            RenderUtils.drawRoundedRect(screenWidth / 2 - width / 2 + 5 + (width - 10) / 2 - 20, 34 + (height - 100) + 5, (width - 10) / 2 + 20, 60, 5, ColorPallet.WARNING.getColor());
            RenderUtils.drawString(this.getAlreadyBoughtText(this.buyer), screenWidth / 2 - width / 2 + 5 + (width - 10) / 2 + 5 - 20, 34 + (height - 100) + 5 + 5, ColorPallet.WHITE.getColor(), 40);
        }
        if (!BinGuiCurrent.isMouseOverCancel(mouseX, mouseY, screenWidth, screenHeight, width, height)) {
            if (this.buyer == null) {
                RenderUtils.drawRoundedRect(screenWidth / 2 - width / 2 + 5 + (width - 10) / 2 - 20, 34 + (height - 100) + 5, (width - 10) / 2 + 20, 60, 5, RenderUtils.setAlpha(ColorPallet.WHITE.getColor(), 50));
                RenderUtils.drawString(this.buyText, screenWidth / 2 - width / 2 + 5 + (width - 10) / 2 + 5 - 20, 34 + (height - 100) + 5 + 5, ColorPallet.WHITE.getColor(), 40);
            }
            if (this.isClicked() && this.buyer == null) {
                if (this.buyState == BuyState.INIT) {
                    this.field_146297_k.field_71439_g.func_85030_a("random.click", 1.0f, 1.0f);
                    this.buyText = "Click again to confirm";
                    this.buyState = BuyState.PURCHASE;
                } else if (this.buyState == BuyState.CONFIRM) {
                    this.field_146297_k.field_71439_g.func_85030_a("random.click", 1.0f, 1.0f);
                    this.buyText = "Buying";
                    this.buyState = BuyState.BUYING;
                }
            }
        }
    }

    public String getAlreadyBoughtText(String buyer) {
        return "\u00a75\u00a7o\u00a77Bought by \u00a7b" + buyer;
    }

    @SubscribeEvent
    public void onGuiMouseInput(GuiScreenEvent.MouseInputEvent event) {
        if (event.gui instanceof BinGuiCurrent) {
            int dwheel = Mouse.getDWheel();
            this.pixelsScrolled += dwheel / 4;
        }
    }

    public void resetGUI() {
        this.buyState = BuyState.INIT;
        this.buyText = "Buy (You can click anywhere)";
        this.itemStack = null;
        this.hasInitialMouseSet = false;
        this.isRendered = false;
        this.isClosing = true;
        Mouse.setGrabbed((boolean)true);
        this.field_146297_k.field_71439_g.func_71053_j();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public static Item getItemByText(String id) {
        try {
            ResourceLocation resourcelocation = new ResourceLocation(id);
            if (!Item.field_150901_e.func_148741_d((Object)resourcelocation)) {
                throw new NumberInvalidException("block.notFound", new Object[]{resourcelocation});
            }
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)resourcelocation);
            if (item == null) {
                throw new NumberInvalidException("block.notFound", new Object[]{resourcelocation});
            }
            return item;
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            return null;
        }
    }

    public static ItemStack getSkull(String displayName, String uuid, String value) {
        String url = "https://textures.minecraft.net/texture/" + value;
        ItemStack render = new ItemStack(Items.field_151144_bL, 1, 3);
        NBTTagCompound skullOwner = new NBTTagCompound();
        skullOwner.func_74778_a("Id", uuid);
        skullOwner.func_74778_a("Name", uuid);
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", url).getBytes());
        NBTTagCompound textures_0 = new NBTTagCompound();
        textures_0.func_74778_a("Value", new String(encodedData));
        NBTTagList textures = new NBTTagList();
        textures.func_74742_a((NBTBase)textures_0);
        NBTTagCompound display = new NBTTagCompound();
        display.func_74778_a("Name", displayName);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("display", (NBTBase)display);
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74782_a("textures", (NBTBase)textures);
        skullOwner.func_74782_a("Properties", (NBTBase)properties);
        tag.func_74782_a("SkullOwner", (NBTBase)skullOwner);
        render.func_77982_d(tag);
        return render;
    }

    @SubscribeEvent
    public void onChatEvent(ClientChatReceivedEvent event) {
        String message = event.message.func_150254_d().toLowerCase(Locale.ROOT);
        if (message.contains("you have bought") || message.contains("you don't have enough coins") || message.contains("this auction wasn't found") || message.contains("there was an error with the auction house") || message.contains("you didn't participate in this auction") || message.contains("you claimed") || message.contains("you purchased") || message.contains("you cannot view this auction")) {
            this.resetGUI();
        }
    }

    public ItemStack getItem(int slotNum, GuiChest currentScreen) {
        ContainerChest container = (ContainerChest)currentScreen.field_147002_h;
        return container.func_75139_a(slotNum).func_75211_c();
    }

    public boolean waitingForBed(GuiChest currentScreen) {
        ItemStack bedStack = this.getItem(31, currentScreen);
        if (bedStack == null || !bedStack.func_77973_b().equals(Item.func_111206_d((String)"minecraft:bed"))) {
            return false;
        }
        ItemStack itemStack = this.getItem(13, currentScreen);
        if (itemStack == null) {
            return false;
        }
        List itemTooltip = itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
        for (String data : itemTooltip) {
            String timeData;
            Matcher matcher = CAN_BUY_IN_MATCHER.matcher(EnumChatFormatting.func_110646_a((String)data));
            if (!matcher.find() || !(timeData = matcher.group(1)).equals("Soon!")) continue;
            return true;
        }
        return false;
    }

    public String isAlreadyBought(String[] tooltip) {
        for (String data : tooltip) {
            Matcher matcher = BUYER_MATCHER.matcher(EnumChatFormatting.func_110646_a((String)data));
            if (!matcher.find()) continue;
            return data.replaceAll("\u00a75\u00a7o\u00a77Buyer: ", "");
        }
        return null;
    }

    private static boolean isMouseOverCancel(int mouseX, int mouseY, int screenWidth, int screenHeight, int width, int height) {
        return mouseX > screenWidth / 2 - width / 2 + 5 && mouseX < screenWidth / 2 - width / 2 + 5 + (width - 10) / 2 - 25 && mouseY > 34 + (height - 100) + 5 && mouseY < 34 + (height - 100) + 5 + 60;
    }

    private static boolean isMouseOverAccept(int mouseX, int mouseY, int screenWidth, int screenHeight, int width, int height) {
        return mouseX > screenWidth / 2 - width / 2 + 5 + (width - 10) / 2 - 20 && mouseX < screenWidth / 2 - width / 2 + 5 + (width - 10) / 2 - 20 + (width - 10) / 2 + 20 && mouseY > 34 + (height - 100) + 5 && mouseY < 34 + (height - 100) + 5 + 60;
    }

    public boolean isClicked() {
        return this.wasMouseDown && !Mouse.isButtonDown((int)0);
    }

    @SubscribeEvent
    public void onRenderEvent(TickEvent.RenderTickEvent event) {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            this.wasMouseDown = Mouse.isButtonDown((int)0);
        }
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!Mouse.getEventButtonState()) {
            return;
        }
        if (this.isRendered) {
            event.setCanceled(true);
        }
    }
}

