/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky;

import de.torui.coflsky.commands.models.TimerData;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CountdownTimer {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static FontRenderer fr = CountdownTimer.mc.field_71466_p;
    private static long currentEndTime;
    private static int currentWidth;
    private static int currentHeight;
    private static double currentScale;
    private static String currentPrefix;
    private static int currentPrecision;

    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (currentEndTime - System.currentTimeMillis() > 0L) {
            CountdownTimer.drawTimer();
        }
    }

    public static void startCountdown(double seconds, int widthPercentage, int heightPercentage, double fontScale) {
        CountdownTimer.startCountdown(seconds, widthPercentage, heightPercentage, fontScale, "", 4);
    }

    public static void startCountdown(double seconds, int widthPercentage, int heightPercentage, double fontScale, String prefix, int maxPrecision) {
        System.out.println("###Starting countdown " + seconds);
        currentEndTime = (long)((double)System.currentTimeMillis() + seconds * 1000.0);
        currentWidth = widthPercentage;
        currentHeight = heightPercentage;
        currentScale = fontScale;
        currentPrefix = prefix;
        currentPrecision = maxPrecision;
    }

    public static void startCountdown(TimerData data) {
        CountdownTimer.startCountdown(data.seconds, data.width, data.height, data.scale, data.prefix, data.maxPrecision);
    }

    private static void drawTimer() {
        long curMillis = currentEndTime - System.currentTimeMillis();
        String render = CountdownTimer.getStringFromDouble((double)curMillis / 1000.0);
        ScaledResolution scaled = new ScaledResolution(mc);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)currentScale, (double)currentScale, (double)currentScale);
        int scaledX = (int)((double)scaled.func_78326_a() * ((double)currentWidth / 100.0) / currentScale);
        int scaledY = (int)((double)scaled.func_78328_b() * ((double)currentHeight / 100.0) / currentScale);
        CountdownTimer.drawHVCenteredString(currentPrefix + render, scaledX, scaledY);
        GlStateManager.func_179121_F();
    }

    private static String getStringFromDouble(double seconds) {
        String render;
        if (seconds > 100.0) {
            render = String.valueOf((int)seconds);
        } else {
            render = String.format(Locale.US, "%.3f", seconds).substring(0, currentPrecision);
            if (render.charAt(render.length() - 1) == '.') {
                render = render.substring(0, currentPrecision - 1);
            }
        }
        return render + "s";
    }

    public static void drawHVCenteredString(String text, int x, int y) {
        text = text.replaceAll("\u00a7", "\u00a7");
        fr.func_175065_a(text, (float)(x - (fr.func_78256_a(text) >> 1)), (float)(y - (CountdownTimer.fr.field_78288_b >> 1)), -1, true);
    }
}

