/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky.handlers;

import de.torui.coflsky.Config;
import de.torui.coflsky.network.QueryServerCommands;
import de.torui.coflsky.network.WSClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class DescriptionHandler {
    public static HashMap<ItemStack, DescModification[]> tooltipItemMap = new HashMap();
    public static HashMap<String, DescModification[]> tooltipItemIdMap = new HashMap();
    public static final DescModification[] EMPTY_ARRAY = new DescModification[0];
    public static final NBTTagCompound EMPTY_COMPOUND = new NBTTagCompound();
    private boolean IsOpen = true;
    private boolean shouldUpdate = false;

    public void Close() {
        this.IsOpen = false;
    }

    public static String ExtractStackableIdFromItemStack(ItemStack stack) {
        if (stack != null) {
            try {
                String uuid = stack.serializeNBT().func_74775_l("tag").func_74775_l("ExtraAttributes").func_74779_i("id") + ":" + stack.field_77994_a;
                if (uuid.length() == 0) {
                    throw new Exception();
                }
                return uuid;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static String ExtractIdFromItemStack(ItemStack stack) {
        if (stack != null) {
            try {
                String uuid = stack.serializeNBT().func_74775_l("tag").func_74775_l("ExtraAttributes").func_74779_i("uuid");
                if (uuid.length() == 0) {
                    throw new Exception();
                }
                return uuid;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DescriptionHandler.ExtractStackableIdFromItemStack(stack);
    }

    private DescModification[] getTooltipData(ItemStack itemStack) {
        if (tooltipItemMap.containsKey(itemStack)) {
            return tooltipItemMap.getOrDefault(itemStack, EMPTY_ARRAY);
        }
        String id = DescriptionHandler.ExtractIdFromItemStack(itemStack);
        if (tooltipItemIdMap.containsKey(id)) {
            return tooltipItemIdMap.getOrDefault(id, EMPTY_ARRAY);
        }
        this.shouldUpdate = true;
        return EMPTY_ARRAY;
    }

    public void loadDescriptionAndListenForChanges(GuiOpenEvent event) {
        GuiContainer gc = (GuiContainer)event.gui;
        DescriptionHandler.loadDescriptionForInventory(event, gc, false);
        int iteration = 0;
        while (this.IsOpen) {
            ++iteration;
            try {
                Thread.sleep(300 + iteration);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (this.shouldUpdate || iteration % 10 == 0 && DescriptionHandler.hasAnyStackChanged(gc)) {
                this.shouldUpdate = false;
                DescriptionHandler.loadDescriptionForInventory(event, gc, true);
            }
            if (iteration < 30) continue;
            iteration = 30;
        }
    }

    private static boolean hasAnyStackChanged(GuiContainer gc) {
        for (Slot obj : gc.field_147002_h.field_75151_b) {
            ItemStack stack = obj.func_75211_c();
            if (stack == null || tooltipItemMap.containsKey(stack)) continue;
            return true;
        }
        return false;
    }

    private static void loadDescriptionForInventory(GuiOpenEvent event, GuiContainer gc, boolean skipLoadCheck) {
        InventoryWrapper wrapper = new InventoryWrapper();
        if (event.gui instanceof GuiChest) {
            ContainerChest chest;
            IInventory inv;
            if (!skipLoadCheck) {
                DescriptionHandler.waitForChestContentLoad(event, gc);
            }
            if ((inv = (chest = (ContainerChest)((GuiChest)event.gui).field_147002_h).func_85151_d()).func_145818_k_()) {
                Object chestName;
                wrapper.chestName = chestName = inv.func_70005_c_();
            }
        }
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList tl = new NBTTagList();
        for (Slot obj : gc.field_147002_h.field_75151_b) {
            ItemStack stack = obj.func_75211_c();
            if (stack != null) {
                tl.func_74742_a((NBTBase)stack.serializeNBT());
                continue;
            }
            tl.func_74742_a((NBTBase)EMPTY_COMPOUND);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            compound.func_74782_a("i", (NBTBase)tl);
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)baos);
            wrapper.fullInventoryNbt = Base64.getEncoder().encodeToString(baos.toByteArray());
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (Slot obj : gc.field_147002_h.field_75151_b) {
                stacks.add(obj.func_75211_c());
            }
            String data = WSClient.gson.toJson((Object)wrapper);
            String info = QueryServerCommands.PostRequest(Config.BaseUrl + "/api/mod/description/modifications", data);
            DescModification[][] arr = (DescModification[][])WSClient.gson.fromJson(info, DescModification[][].class);
            int i = 0;
            for (ItemStack stack : stacks) {
                tooltipItemMap.put(stack, arr[i]);
                String id = DescriptionHandler.ExtractIdFromItemStack(stack);
                if (id.length() > 0) {
                    tooltipItemIdMap.put(id, arr[i]);
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void waitForChestContentLoad(GuiOpenEvent event, GuiContainer gc) {
        for (int i = 1; i < 10 && ((Slot)gc.field_147002_h.field_75151_b.get(gc.field_147002_h.field_75151_b.size() - 37)).func_75211_c() == null; ++i) {
            try {
                Thread.sleep(20 * i);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setTooltips(ItemTooltipEvent event) {
        DescModification[] data = this.getTooltipData(event.itemStack);
        if (data == null || data.length == 0) {
            return;
        }
        block12: for (DescModification datum : data) {
            if (event.toolTip.size() <= datum.line) {
                System.out.println("Skipped line modification " + datum.line + " for " + event.itemStack.func_82833_r());
                continue;
            }
            switch (datum.type) {
                case "APPEND": {
                    event.toolTip.add(datum.value);
                    continue block12;
                }
                case "REPLACE": {
                    event.toolTip.set(datum.line, datum.value);
                    continue block12;
                }
                case "INSERT": {
                    event.toolTip.add(datum.line, datum.value);
                    continue block12;
                }
                case "DELETE": {
                    event.toolTip.remove(datum.line);
                }
            }
        }
    }

    public static void emptyTooltipData() {
        tooltipItemMap.clear();
        tooltipItemIdMap.clear();
        tooltipItemIdMap.clear();
    }

    private static class DescModification {
        public String type;
        public String value;
        public int line;

        private DescModification() {
        }
    }

    private static class InventoryWrapper {
        public String chestName;
        public String fullInventoryNbt;

        private InventoryWrapper() {
        }
    }
}

