/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky.configuration;

import de.torui.coflsky.configuration.Configuration;
import de.torui.coflsky.configuration.Description;
import de.torui.coflsky.network.WSClient;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ConfigurationManager {
    public Configuration Config = Configuration.getInstance();

    public void UpdateConfiguration(String data) {
        Configuration newConfig = (Configuration)WSClient.gson.fromJson(data, Configuration.class);
        if (newConfig == null) {
            System.out.println("Could not deserialize configuration " + data);
        }
        try {
            if (this.CompareProperties(this.Config, newConfig)) {
                Configuration.setInstance(newConfig);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public boolean CompareProperties(Configuration old, Configuration newConfiguration) throws IllegalArgumentException, IllegalAccessException {
        int updatedProperties = 0;
        block12: for (Field f : Configuration.class.getFields()) {
            switch (f.getGenericType().getTypeName()) {
                case "int": {
                    if (f.getInt(old) == f.getInt(newConfiguration)) continue block12;
                    this.UpdatedProperty(f, newConfiguration);
                    ++updatedProperties;
                    continue block12;
                }
                case "boolean": {
                    if (f.getBoolean(old) == f.getBoolean(newConfiguration)) continue block12;
                    this.UpdatedProperty(f, newConfiguration);
                    ++updatedProperties;
                    continue block12;
                }
                case "java.lang.String": {
                    if (f.get(old) == null || f.get(old).equals(f.get(newConfiguration))) continue block12;
                    this.UpdatedProperty(f, newConfiguration);
                    ++updatedProperties;
                    continue block12;
                }
                case "java.lang.String[]": {
                    if (Arrays.deepEquals((String[])f.get(old), (String[])f.get(newConfiguration))) continue block12;
                    this.UpdatedProperty(f, newConfiguration);
                    ++updatedProperties;
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Invalid Configuration Type " + f.getGenericType().getTypeName());
                }
            }
        }
        return updatedProperties > 0;
    }

    private IChatComponent GetNameFormatted(Field propertyName) {
        Description description = propertyName.getAnnotation(Description.class);
        ChatComponentText toReturn = new ChatComponentText(propertyName.getName());
        ChatStyle style = new ChatStyle();
        style.func_150238_a(EnumChatFormatting.WHITE);
        if (description != null) {
            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(description.value())));
        }
        return toReturn.func_150255_a(style);
    }

    public void UpdatedProperty(Field propertyName, Configuration confignew) throws IllegalAccessException {
        System.out.println("The Configuration Setting " + propertyName.getName() + " has been updated to " + propertyName.get(confignew));
    }
}

