/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky;

import de.torui.coflsky.commands.models.FlipData;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class FlipHandler {
    public FlipDataStructure fds = new FlipDataStructure();
    public String lastClickedFlipMessage;

    public static class FlipDataStructure {
        private Map<Long, FlipData> Flips = new ConcurrentHashMap<Long, FlipData>();
        private Map<FlipData, Long> ReverseMap = new ConcurrentHashMap<FlipData, Long>();
        private FlipData HighestFlip = null;
        private FlipData LastFlip = null;
        private Timer t = new Timer();
        private TimerTask CurrentTask = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void RunHouseKeeping() {
            Map<Long, FlipData> map = this.Flips;
            synchronized (map) {
                Long RemoveAllPrior = System.currentTimeMillis() - 42000L;
                this.Flips.keySet().stream().filter(l -> l <= RemoveAllPrior).forEach(l -> this.RemoveLong((Long)l));
                this.HighestFlip = !this.Flips.isEmpty() ? (FlipData)this.Flips.values().stream().max((f1, f2) -> f1.Worth - f2.Worth).orElse(null) : null;
            }
            if (this.CurrentTask != null) {
                this.CurrentTask.cancel();
                this.CurrentTask = null;
                this.t.purge();
            }
            if (!this.Flips.isEmpty()) {
                this.CurrentTask = new TimerTask(){

                    @Override
                    public void run() {
                        this.RunHouseKeeping();
                    }
                };
                this.t.schedule(this.CurrentTask, 42150L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Insert(FlipData flip) {
            Long l = System.currentTimeMillis();
            this.LastFlip = flip;
            Map<Long, FlipData> map = this.Flips;
            synchronized (map) {
                this.Flips.put(l, flip);
                this.ReverseMap.put(flip, l);
            }
            this.RunHouseKeeping();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void RemoveLong(Long l) {
            if (l == null) {
                return;
            }
            Map<Long, FlipData> map = this.Flips;
            synchronized (map) {
                FlipData f = this.Flips.get(l);
                if (f != null) {
                    this.ReverseMap.remove(f);
                    this.Flips.remove(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void RemoveFlip(FlipData f) {
            if (f == null) {
                return;
            }
            Map<Long, FlipData> map = this.Flips;
            synchronized (map) {
                Long l = this.ReverseMap.get(f);
                if (l != null) {
                    this.Flips.remove(l);
                    this.ReverseMap.remove(f);
                }
            }
        }

        public FlipData GetHighestFlip() {
            return this.HighestFlip;
        }

        public FlipData GetLastFlip() {
            if (this.LastFlip == null) {
                return null;
            }
            Long l = this.ReverseMap.get(this.LastFlip);
            if (l == null) {
                this.LastFlip = null;
            }
            return this.LastFlip;
        }

        public FlipData getFlipById(String id) {
            FlipData[] flips = (FlipData[])this.Flips.values().stream().filter(flipData -> flipData.Id.equals(id)).toArray(FlipData[]::new);
            this.Flips.forEach((key, value) -> System.out.println(value.Id));
            if (flips.length == 0) {
                return null;
            }
            return flips[0];
        }

        public void InvalidateFlip(FlipData flip) {
            this.RemoveFlip(flip);
            this.RunHouseKeeping();
        }

        public int CurrentFlips() {
            return this.Flips.size();
        }
    }
}

