/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky;

import com.google.gson.Gson;
import de.torui.coflsky.CoflSkyCommand;
import de.torui.coflsky.ColfCommand;
import de.torui.coflsky.Config;
import de.torui.coflsky.FlipperChatCommand;
import de.torui.coflsky.WSCommandHandler;
import de.torui.coflsky.configuration.LocalConfig;
import de.torui.coflsky.gui.GUIType;
import de.torui.coflsky.gui.tfm.ButtonRemapper;
import de.torui.coflsky.gui.tfm.ChatMessageSendHandler;
import de.torui.coflsky.handlers.EventRegistry;
import de.torui.coflsky.listeners.ChatListener;
import de.torui.coflsky.network.WSClientWrapper;
import de.torui.coflsky.proxy.APIKeyManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="CoflSky", version="1.5.0-Alpha")
public class CoflSky {
    public static final String MODID = "CoflSky";
    public static final String VERSION = "1.5.0-Alpha";
    public static WSClientWrapper Wrapper;
    public static KeyBinding[] keyBindings;
    public static EventRegistry Events;
    public static File configFile;
    private File coflDir;
    public static LocalConfig config;
    public static final String[] webSocketURIPrefix;
    public static String CommandUri;
    private static final APIKeyManager apiKeyManager;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String configString = null;
        Gson gson = new Gson();
        this.coflDir = new File(event.getModConfigurationDirectory(), MODID);
        this.coflDir.mkdirs();
        configFile = new File(this.coflDir, "config.json");
        try {
            if (configFile.isFile()) {
                configString = new String(Files.readAllBytes(Paths.get(configFile.getPath(), new String[0])));
                config = (LocalConfig)gson.fromJson(configString, LocalConfig.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (config == null) {
            config = LocalConfig.createDefaultConfig();
        }
        try {
            apiKeyManager.loadIfExists();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        MinecraftForge.EVENT_BUS.register((Object)new ChatListener());
        WSCommandHandler.cacheMods();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Wrapper = new WSClientWrapper(webSocketURIPrefix);
        keyBindings = new KeyBinding[]{new KeyBinding("key.replay_last.onclick", 0, "SkyCofl"), new KeyBinding("key.start_highest_bid", 0, "SkyCofl")};
        if (event.getSide() == Side.CLIENT) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CoflSkyCommand());
            ClientCommandHandler.instance.func_71560_a((ICommand)new ColfCommand());
            ClientCommandHandler.instance.func_71560_a((ICommand)new FlipperChatCommand());
            for (int i = 0; i < keyBindings.length; ++i) {
                ClientRegistry.registerKeyBinding((KeyBinding)keyBindings[i]);
            }
        }
        Events = new EventRegistry();
        MinecraftForge.EVENT_BUS.register((Object)Events);
        if (CoflSky.config.purchaseOverlay == GUIType.TFM) {
            MinecraftForge.EVENT_BUS.register((Object)ButtonRemapper.getInstance());
        }
        MinecraftForge.EVENT_BUS.register((Object)new ChatMessageSendHandler());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LocalConfig.saveConfig(configFile, config);
            try {
                apiKeyManager.saveKey();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }));
    }

    public static APIKeyManager getAPIKeyManager() {
        return apiKeyManager;
    }

    static {
        webSocketURIPrefix = new String[]{"wss://sky.coflnet.com/modsocket", "wss://sky-mod.coflnet.com/modsocket", "ws://sky.coflnet.com/modsocket", "ws://sky-mod.coflnet.com/modsocket"};
        CommandUri = Config.BaseUrl + "/api/mod/commands";
        apiKeyManager = new APIKeyManager();
    }
}

