/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky.proxy;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;

public class APIKeyManager {
    private final Gson gson = new Gson();
    private APIInfo apiInfo = new APIInfo();

    public APIInfo getApiInfo() {
        return this.apiInfo;
    }

    public void loadIfExists() throws Exception {
        Path dataPath = Paths.get(Loader.instance().getConfigDir().getPath(), "CoflSky", "api-key.json");
        File file = dataPath.toFile();
        if (file.exists()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String raw = reader.lines().collect(Collectors.joining("\n"));
            this.apiInfo = (APIInfo)this.gson.fromJson(raw, APIInfo.class);
            reader.close();
        }
    }

    public void saveKey() throws Exception {
        Path dataPath = Paths.get(Loader.instance().getConfigDir().getPath(), "CoflSky", "api-key.json");
        File file = dataPath.toFile();
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        String data = this.gson.toJson((Object)this.apiInfo);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        bw.append(data);
        bw.flush();
        bw.close();
    }

    public class APIInfo {
        @SerializedName(value="api-key")
        public String key;
    }
}

