/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky.minecraft_integration;

import de.torui.coflsky.network.WSClient;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import net.minecraft.client.Minecraft;

public class PlayerDataProvider {
    public static String getActivePlayerUUID() {
        try {
            int length;
            URL url = new URL("https://api.mojang.com/profiles/minecraft");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            con.setRequestProperty("Accept", "application/json");
            con.setDoInput(true);
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            byte[] bytes = ("[\"" + PlayerDataProvider.getUsername() + "\"]").getBytes("UTF-8");
            os.write(bytes);
            os.close();
            BufferedInputStream in = new BufferedInputStream(con.getInputStream());
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String resString = result.toString("UTF-8");
            System.out.println("Result= " + resString);
            UUIDHelper[] helpers = (UUIDHelper[])WSClient.gson.fromJson(resString, UUIDHelper[].class);
            if (helpers.length == 1) {
                return helpers[0].id;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return UUID.randomUUID().toString();
    }

    public static String getUsername() {
        String username = (String)Minecraft.func_175596_ai().get("X-Minecraft-Username");
        return username;
    }

    public static PlayerPosition getPlayerPosition() {
        PlayerPosition pos = new PlayerPosition();
        pos.X = Minecraft.func_71410_x().field_71439_g.field_70165_t;
        pos.Y = Minecraft.func_71410_x().field_71439_g.field_70163_u;
        pos.Z = Minecraft.func_71410_x().field_71439_g.field_70161_v;
        pos.Yaw = Minecraft.func_71410_x().field_71439_g.field_70177_z;
        pos.Pitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
        return pos;
    }

    public static class PlayerPosition {
        public double X;
        public double Y;
        public double Z;
        public float Yaw;
        public float Pitch;
    }

    private static class UUIDHelper {
        public String id;
        public String name;

        private UUIDHelper() {
        }
    }
}

