/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky.minecraft_integration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;

public class CoflSessionManager {
    public static Gson gson = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new TypeAdapter<ZonedDateTime>(){

        public void write(JsonWriter out, ZonedDateTime value) throws IOException {
            out.value(value.toString());
        }

        public ZonedDateTime read(JsonReader in) throws IOException {
            return ZonedDateTime.parse(in.nextString());
        }
    }).enableComplexMapKeySerialization().create();

    public static void UpdateCoflSessions() throws IOException {
        Map<String, CoflSession> sessions = CoflSessionManager.GetCoflSessions();
        for (String username : sessions.keySet()) {
            if (CoflSessionManager.isValidSession(sessions.get(username))) continue;
            CoflSessionManager.DeleteCoflSession(username);
        }
    }

    public static Path GetTempFileFolder() {
        Path dataPath = Paths.get(Loader.instance().getConfigDir().getPath(), "CoflSky", "sessions");
        dataPath.toFile().mkdirs();
        return dataPath;
    }

    public static Map<String, CoflSession> GetCoflSessions() throws IOException {
        File[] sessions = CoflSessionManager.GetTempFileFolder().toFile().listFiles();
        HashMap<String, CoflSession> map = new HashMap<String, CoflSession>();
        for (int i = 0; i < sessions.length; ++i) {
            map.put(sessions[i].getName(), CoflSessionManager.GetCoflSession(sessions[i].getName()));
        }
        return map;
    }

    public static boolean isValidSession(CoflSession session) {
        return session.timestampCreated.plus(Duration.ofDays(14L)).isAfter(ZonedDateTime.now());
    }

    private static Path GetUserPath(String username) {
        return Paths.get(CoflSessionManager.GetTempFileFolder().toString() + "/" + username, new String[0]);
    }

    public static void DeleteCoflSession(String username) {
        Path path = CoflSessionManager.GetUserPath(username);
        path.toFile().delete();
    }

    public static void DeleteAllCoflSessions() {
        File[] sessions;
        Path path = CoflSessionManager.GetTempFileFolder();
        for (File f : sessions = path.toFile().listFiles()) {
            f.delete();
        }
    }

    public static CoflSession GetCoflSession(String username) throws IOException {
        Path path = CoflSessionManager.GetUserPath(username);
        File file = path.toFile();
        if (!file.exists()) {
            CoflSession session = new CoflSession(UUID.randomUUID().toString(), ZonedDateTime.now());
            CoflSessionManager.OverwriteCoflSession(username, session);
            return session;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String raw = reader.lines().collect(Collectors.joining("\n"));
        reader.close();
        CoflSession session = (CoflSession)gson.fromJson(raw, CoflSession.class);
        return session;
    }

    public static boolean OverwriteCoflSession(String username, CoflSession session) throws IOException {
        Path path = CoflSessionManager.GetUserPath(username);
        File file = path.toFile();
        file.createNewFile();
        String data = gson.toJson((Object)session);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        bw.append(data);
        bw.flush();
        bw.close();
        return true;
    }

    public static class CoflSession {
        public String SessionUUID;
        public ZonedDateTime timestampCreated;

        public CoflSession() {
        }

        public CoflSession(String sessionUUID, ZonedDateTime timestampCreated) {
            this.SessionUUID = sessionUUID;
            this.timestampCreated = timestampCreated;
        }
    }
}

