/*
 * Decompiled with CFR 0.152.
 */
package com.craftsphere.server;

import com.craftsphere.common.NetworkHandler;
import com.craftsphere.common.packets.DimensionSyncPacket;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="craftsphere")
public class DimensionHandler {
    private static final Set<UUID> playersWithMod = new HashSet<UUID>();
    private static final Set<UUID> playersBeingChecked = new HashSet<UUID>();

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        try {
            NetworkHandler.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        UUID playerId;
        ServerPlayer player;
        block3: {
            if (!(event.getEntity() instanceof ServerPlayer)) {
                return;
            }
            player = (ServerPlayer)event.getEntity();
            playerId = player.m_20148_();
            playersWithMod.remove(playerId);
            playersBeingChecked.add(playerId);
            try {
                NetworkHandler.getChannel().sendTo((Object)new DimensionSyncPacket(), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
            catch (Exception e) {
                if (player.f_8906_ == null) break block3;
                MutableComponent disconnectMessage = Component.m_237113_((String)"\u00a7c\u00a7lCRAFTSPHERE DIMENSIONS REQUIRED!\n\n\u00a77This server features exclusive dimensions and content!\n\n\u00a7eYou need CraftSphere Dimensions mod to play.\n\u00a7eVersion Required: \u00a7b1.3.2\n\n\u00a76Download exclusively from our Discord:\n\u00a7b\u00a7ndiscord.gg/CraftSphere\n\n\u00a77Join our Discord server to download the mod and\n\u00a77access the exclusive VoidRealm dimension with\n\u00a77epic dungeons, legendary treasures, and adventures!\n\n\u00a7cYou cannot connect without this mod.");
                player.f_8906_.m_9942_((Component)disconnectMessage);
                return;
            }
        }
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(3000L);
                if (!playersWithMod.contains(playerId) && playersBeingChecked.contains(playerId) && player.m_6084_() && player.f_8906_ != null) {
                    MutableComponent disconnectMessage = Component.m_237113_((String)"\u00a7c\u00a7lCRAFTSPHERE DIMENSIONS REQUIRED!\n\n\u00a77This server features exclusive dimensions and content!\n\n\u00a7eYou need CraftSphere Dimensions mod to play.\n\u00a7eVersion Required: \u00a7b1.3.2\n\n\u00a76Download exclusively from our Discord:\n\u00a7b\u00a7ndiscord.gg/CraftSphere\n\n\u00a77Join our Discord server to download the mod and\n\u00a77access the exclusive VoidRealm dimension with\n\u00a77epic dungeons, legendary treasures, and adventures!\n\n\u00a7cYou cannot connect without this mod.");
                    player.f_8906_.m_9942_((Component)disconnectMessage);
                }
                playersBeingChecked.remove(playerId);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    public static void markPlayerHasMod(UUID playerId) {
        playersWithMod.add(playerId);
        playersBeingChecked.remove(playerId);
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID playerId = event.getEntity().m_20148_();
        playersWithMod.remove(playerId);
        playersBeingChecked.remove(playerId);
    }
}

